/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMLocalTimestamp;
import com.cognos.cmutils.date.DateUtils;
import java.sql.Timestamp;
import java.util.Calendar;

public class CMDbStoreTimestampSerializer
implements CMDbStoreDataSerializer {
    @Override
    public Object serialize(Object input) throws CMException {
        if (input == null || input instanceof Timestamp) {
            return input;
        }
        boolean isDerby = CMDbConnection.dbms_ == 5;
        return CMDateUtils.getTimestamp(DateUtils.parse((String)((String)input)), isDerby);
    }

    @Override
    public Object deserialize(Object input) {
        Timestamp value = (Timestamp)input;
        if (value == null) {
            return null;
        }
        if (input instanceof CMLocalTimestamp) {
            return new CMDbStoreString(CMDateUtils.getIsoDate(value, DateUtils.getDSTNeutralCalendar()));
        }
        return new CMDbStoreString(CMDateUtils.getIsoDate(value, Calendar.getInstance()));
    }

    @Override
    public boolean lobIsNull(Object input) {
        return input == null;
    }
}

