/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePair;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePairArray;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.properties.CMTypedNameValuePairArray;
import com.cognos.cm.server.CMException;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.Reader;

public class CMDbStoreTypedNameValuePairArraySerializer
implements CMDbStoreDataSerializer {
    private CMDbProperty property_;

    public CMDbStoreTypedNameValuePairArraySerializer(CMDbProperty prop) {
        this.property_ = prop;
    }

    @Override
    public final Object serialize(Object input) throws CMException {
        CMTypedNameValuePairArray array = (CMTypedNameValuePairArray)input;
        if (array == null || array.getSize() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(1024);
        int itemCount = array.getSize();
        for (int itemIdx = 0; itemIdx != itemCount; ++itemIdx) {
            CMTypedNameValuePair nvPair = array.getPair(itemIdx);
            String datum = nvPair.getName();
            String type = nvPair.getTypeName();
            if (datum == null || type == null) {
                throw new IllegalStateException("Name and type cannot be null for TypedNameValuePair");
            }
            short nameEnumID = this.property_.getNameEnumID(datum);
            if (nameEnumID == -1) {
                throw new CMException("cmBadPropValue", new CMException.Parm("Value", datum));
            }
            short typeEnumID = this.property_.getTypeEnumID(type);
            if (typeEnumID == -1) {
                throw new CMException("cmBadPropValue", new CMException.Parm("Value", type));
            }
            buffer.append(nameEnumID);
            buffer.append(";");
            buffer.append(typeEnumID);
            buffer.append(";");
            buffer.append(nvPair.getValue().length());
            buffer.append(";");
            buffer.append(nvPair.getValue());
        }
        return buffer.toString();
    }

    @Override
    public final Object deserialize(Object input) {
        int semicPos;
        if (input == null) {
            return null;
        }
        String value = null;
        if (input instanceof Reader) {
            try {
                value = CMStreamUtils.readReaderIntoString((Reader)((Reader)input));
            }
            catch (IOException iOException) {}
        } else {
            value = input.toString();
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        CMDbStoreTypedNameValuePairArray newArray = new CMDbStoreTypedNameValuePairArray();
        int curPos = 0;
        int dataLength = value.length();
        while (curPos < dataLength && (semicPos = value.indexOf(";", curPos)) >= 0) {
            short nameID = Short.parseShort(value.substring(curPos, semicPos++));
            curPos = semicPos;
            if ((semicPos = value.indexOf(";", semicPos)) < 0) break;
            short typeID = Short.parseShort(value.substring(curPos, semicPos++));
            curPos = semicPos;
            if ((semicPos = value.indexOf(";", semicPos)) < 0) break;
            int valueLen = Integer.parseInt(value.substring(curPos, semicPos++));
            String dataValue = value.substring(semicPos, semicPos + valueLen);
            curPos = semicPos + valueLen;
            String optionName = this.property_.getNameEnumString(nameID);
            String typeName = this.property_.getTypeEnumString(typeID);
            newArray.add(new CMDbStoreTypedNameValuePair(optionName, dataValue, typeName));
        }
        if (newArray.getSize() > 0) {
            return newArray;
        }
        return null;
    }

    @Override
    public boolean lobIsNull(Object input) {
        return input == null || ((CMArrayPropertyValue)input).getSize() == 0;
    }
}

