/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePair;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMStringUtils;
import java.io.IOException;
import java.io.InputStream;

public class CMDbStoreTypedNameValuePairSerializer
implements CMDbStoreDataSerializer {
    private CMDbProperty property_;

    public CMDbStoreTypedNameValuePairSerializer(CMDbProperty prop) {
        this.property_ = prop;
    }

    @Override
    public final Object serialize(Object input) throws CMException {
        short nameID;
        CMTypedNameValuePair value = (CMTypedNameValuePair)input;
        String datum = value.getName();
        String type = value.getTypeName();
        if (datum == null || type == null) {
            throw new IllegalStateException("Name and type cannot be null for TypedNameValuePair");
        }
        byte[] data = null;
        if (CMDbConnection.dbms_ != 2 || CMDbConnection.getDbmsInfo().getIsThinDriver()) {
            try {
                data = CMStringUtils.compressUTF8String(value.getValue());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((nameID = this.property_.getNameEnumID(datum)) == -1) {
            throw new CMException("cmBadPropValue", new CMException.Parm("Value", datum));
        }
        short typeID = this.property_.getTypeEnumID(type);
        if (typeID == -1) {
            throw new CMException("cmBadPropValue", new CMException.Parm("Value", type));
        }
        return new Object[]{new Short(nameID), new Short(typeID), data};
    }

    @Override
    public final Object deserialize(Object input) {
        Object[] data = (Object[])input;
        short nameID = (Short)data[0];
        short typeID = (Short)data[1];
        String optionName = this.property_.getNameEnumString(nameID);
        String typeName = this.property_.getTypeEnumString(typeID);
        String optionValue = null;
        try {
            optionValue = CMStringUtils.decompressUTF8String((InputStream)data[2]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CMDbStoreTypedNameValuePair(optionName, optionValue, typeName);
    }

    @Override
    public boolean lobIsNull(Object input) {
        CMTypedNameValuePair value = (CMTypedNameValuePair)input;
        return value.getValue().length() == 0;
    }
}

