/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreUncheckedArray;
import com.cognos.cm.dbstore.serializers.CMDbStoreStringCompressingSerializer;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMStringUtils;
import java.io.IOException;
import java.io.InputStream;

public class CMDbStoreUncheckedArraySerializer
implements CMDbStoreDataSerializer {
    private CMPropertyTypes.Type type_ = null;

    public CMDbStoreUncheckedArraySerializer(Object arrayType) {
        this.type_ = (CMPropertyTypes.Type)arrayType;
    }

    @Override
    public final Object serialize(Object input) throws CMException {
        if (input == null) {
            return null;
        }
        CMDbStoreUncheckedArray array = (CMDbStoreUncheckedArray)input;
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(array.getSize());
        buffer.append(";");
        buffer.append(array.getXMLContent());
        CMDbStoreStringCompressingSerializer stringCompressingSerializer = new CMDbStoreStringCompressingSerializer();
        return stringCompressingSerializer.serialize(buffer.toString());
    }

    @Override
    public final Object deserialize(Object input) {
        if (input == null) {
            return null;
        }
        String decompressedValue = null;
        try {
            decompressedValue = CMStringUtils.decompressUTF8String((InputStream)input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (decompressedValue == null) {
            return null;
        }
        int semiPos = decompressedValue.indexOf(";");
        if (semiPos < 0) {
            return null;
        }
        int number = Integer.parseInt(decompressedValue.substring(0, semiPos));
        return new CMDbStoreUncheckedArray(this.type_, number, decompressedValue.substring(semiPos + 1));
    }

    @Override
    public boolean lobIsNull(Object input) {
        CMDbStoreUncheckedArray items = (CMDbStoreUncheckedArray)input;
        return items == null || items.getSize() == 0;
    }
}

