/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.statement;

import com.cognos.cm.dbstore.CMDbmsInfo;
import com.cognos.cm.dbstore.statement.FunctionHandler;
import com.cognos.cm.dbstore.statement.InformixDialect;
import com.cognos.cm.dbstore.statement.SybaseDialect;
import java.util.ArrayList;

public class BaseDialect
implements FunctionHandler {
    public String lobNotNull(ArrayList<String> args) {
        if (args.size() != 1) {
            throw new IllegalStateException("Invalid number of arguments");
        }
        return args.get(0) + " is not null";
    }

    public String lobIsNull(ArrayList<String> args) {
        if (args.size() != 1) {
            throw new IllegalStateException("Invalid number of arguments");
        }
        return args.get(0) + " is null";
    }

    public String coalesce(ArrayList<String> args) {
        StringBuilder buf = new StringBuilder();
        buf.append("coalesce");
        String sep = "(";
        for (String arg : args) {
            buf.append(sep).append(arg);
            sep = ", ";
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String invoke(String name, ArrayList<String> args) {
        if (name.equals("lobNotNull")) {
            return this.lobNotNull(args);
        }
        if (name.equals("lobIsNull")) {
            return this.lobIsNull(args);
        }
        if (name.equals("coalesce")) {
            return this.coalesce(args);
        }
        throw new IllegalArgumentException("Unsupported function: " + name);
    }

    public static BaseDialect getDialect(CMDbmsInfo dbInfo) {
        switch (dbInfo.getDbms()) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return new BaseDialect();
            }
            case 8: {
                return new InformixDialect();
            }
            case 4: {
                return new SybaseDialect();
            }
        }
        throw new RuntimeException("Unsupported db");
    }
}

