/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.cm.dbstore.properties.CMDbStoreAncestors;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.deployment.DeploymentAncestor;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMQueryUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class AncestorCache {
    private CMStore store;
    private ICMLockManager lockMgr;
    private HashMap<String, DeploymentAncestor> ancestorCache;
    private CMStringLocale defaultLocale;

    public AncestorCache(CMStore store) {
        this.store = store;
        this.lockMgr = store.getLockManager();
        this.ancestorCache = new HashMap();
        this.defaultLocale = CMExecutionContext.get().getCurrentUserContentLocale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DeploymentAncestor> convert(CMAncestors ancestors) throws CMException {
        if (ancestors.getSize() == 1 && ancestors.getObjectClass(0).equals("content")) {
            return null;
        }
        ArrayList<DeploymentAncestor> deployAncestors = new ArrayList<DeploymentAncestor>();
        CMProperty[] props = new CMProperty[]{CMProperty.NAME};
        for (int i = 0; i < ancestors.getSize(); ++i) {
            String storeID = ancestors.getStoreID(i);
            DeploymentAncestor ancestor = this.ancestorCache.get(storeID);
            if (ancestor != null) {
                deployAncestors.add(ancestor);
                continue;
            }
            ancestor = new DeploymentAncestor();
            ancestor.objClass = ancestors.getObjectClass(i);
            ancestor.searchPath = ancestors.getSearchPath(i);
            CMStoreQueryResults results = null;
            CMStoreXPath queryPath = CMStoreXPath.fromStoreID(storeID);
            try {
                results = this.store.executeQuery(queryPath, props, null, 9, 8704, null);
                if (results.next()) {
                    ancestor.name = (CMDbStoreLocalizedStringArray)results.getValue(0);
                }
            }
            catch (Throwable throwable) {
                CMQueryUtils.safeQueryResultsRelease(results);
                this.lockMgr.releaseLocks();
                throw throwable;
            }
            CMQueryUtils.safeQueryResultsRelease(results);
            this.lockMgr.releaseLocks();
            if (ancestor.name == null) {
                throw new CMException("cmObjectNotFoundPath", new CMException.Parm("Path", ancestor.searchPath));
            }
            deployAncestors.add(ancestor);
            this.ancestorCache.put(storeID, ancestor);
        }
        return deployAncestors;
    }

    public CMAncestors convert(ArrayList<DeploymentAncestor> src) {
        CMDbStoreAncestors result = new CMDbStoreAncestors();
        for (DeploymentAncestor item : src) {
            String name = item.name.getDefault(this.defaultLocale);
            result.addChild(name, item.searchPath, item.objClass, null);
        }
        return result;
    }
}

