/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.cm.deployment.DeploymentHistory;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMStringUtils;
import java.util.HashSet;

public class AuthenticatedNamespaces {
    HashSet<String> authenticated;
    HashSet<String> skipped = new HashSet();

    public AuthenticatedNamespaces() {
        this.authenticated = this.getUserAuthenticatedNamespaces();
    }

    private HashSet<String> getUserAuthenticatedNamespaces() {
        HashSet<String> result = new HashSet<String>();
        CMExecutionContext ctx = CMExecutionContext.get();
        if (ctx.getContext().getCurrentUserSession().isAnonymousUser()) {
            return result;
        }
        for (CMObjectReference identity : ctx.getCurrentUserIdentity()) {
            if (identity.getObjectClass() != CMObjectClass.NAMESPACE) continue;
            String nsSearchPath = identity.getSearchPath();
            String nsID = CMCAMIDHelper.getNamespaceIDFromSearchPath(nsSearchPath);
            result.add(nsID);
        }
        return result;
    }

    public boolean containsNamespaceId(String nsID) {
        if (":".equals(nsID)) {
            return false;
        }
        if (!this.authenticated.contains(nsID)) {
            this.skipped.add(nsID);
            return false;
        }
        return true;
    }

    public boolean containsSearchPath(String searchPath) {
        String nsId = CMCAMIDHelper.getNamespaceIDFromSearchPath(searchPath);
        return this.containsNamespaceId(nsId);
    }

    public boolean hasMessage() {
        return !this.skipped.isEmpty();
    }

    public CMException getMessage(boolean isExport) {
        String errorCode = "cmNamespacesNotImported";
        if (isExport) {
            errorCode = "cmNamespacesNotExported";
        }
        String nslist = CMStringUtils.join(", ", this.skipped);
        CMException ex = new CMException(errorCode, new CMException.Parm("Namespaces", nslist));
        ex.ErrorLevel = 30000;
        return ex;
    }

    public void writeMessages(DeploymentHistory history, boolean isExport) {
        if (this.hasMessage()) {
            history.addRootError(this.getMessage(isExport));
        }
    }
}

