/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.cm.cmInfo;
import com.cognos.cm.deployment.DeploymentContent;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.server.C8Edition;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMBuildVersion;
import com.cognos.cm.util.CMSOAPWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ContentFile {
    private static final String TAG_CONTENT = "content";
    private static final String TAG_PLUGINNAME = "pluginName";
    private static final String TAG_PLUGINS = "plugins";
    private static final String TAG_PLUGINVERSION = "pluginVersion";
    private static final String TAG_EXPORTEDPACKAGES = "exportedPackages";
    private static final String TAG_EXPORTEDFOLDERS = "exportedFolders";
    private static final String TAG_EXPORTEDACCOUNTS = "exportedAccounts";
    private static final CMBuildVersion ARCHIVE_CUTOFF_VERSION = new CMBuildVersion(1, 1, 400, 0);
    public ArrayList<DeploymentContent> packages = new ArrayList();
    public ArrayList<DeploymentContent> folders = new ArrayList();
    public ArrayList<DeploymentContent> accounts = new ArrayList();
    public Map<String, String> plugins = null;
    public int archiveVersion;
    public String cmBuildVersion;
    public C8Edition edition;

    public ContentFile(String buildVersion, int archiveVersion, C8Edition edition) {
        this.cmBuildVersion = buildVersion;
        this.archiveVersion = archiveVersion;
        this.edition = edition;
    }

    public ContentFile() {
        this(cmInfo.getVersion(), 7, CMServlet.getEdition());
    }

    public DeploymentContent findRecordByName(String name) {
        for (DeploymentContent cRec : this.packages) {
            if (!cRec.matchesName(name)) continue;
            return cRec;
        }
        return null;
    }

    public DeploymentContent findRecordByPath(String path) {
        for (DeploymentContent cRec : this.packages) {
            if (!(cRec.searchPath == null ? cRec.matchesName(path) : path.equals(cRec.searchPath))) continue;
            return cRec;
        }
        for (DeploymentContent cRec : this.accounts) {
            if (!path.equals(cRec.searchPath)) continue;
            return cRec;
        }
        return null;
    }

    public void writeTo(CMSOAPWriter wrt) {
        ((CMSOAPWriter)wrt.element(TAG_CONTENT)).addDefaultNamespaces();
        ((CMSOAPWriter)((CMSOAPWriter)wrt.element("cmBuildNumber")).text(this.cmBuildVersion)).end();
        ((CMSOAPWriter)((CMSOAPWriter)wrt.element("edition")).text(this.edition.getName())).end();
        ((CMSOAPWriter)((CMSOAPWriter)wrt.element("archiveVersion")).text(Integer.toString(this.archiveVersion))).end();
        if (this.packages.size() != 0) {
            this.writeContentRecord(wrt, TAG_EXPORTEDPACKAGES, this.packages);
        }
        if (this.folders.size() != 0) {
            this.writeContentRecord(wrt, TAG_EXPORTEDFOLDERS, this.folders);
        }
        if (this.accounts.size() != 0) {
            this.writeContentRecord(wrt, TAG_EXPORTEDACCOUNTS, this.accounts);
        }
        if (this.plugins != null && this.plugins.size() != 0) {
            wrt.element(TAG_PLUGINS);
            for (Map.Entry<String, String> entry : this.plugins.entrySet()) {
                if (entry.getValue() == null) continue;
                wrt.element("item");
                ((CMSOAPWriter)((CMSOAPWriter)wrt.element(TAG_PLUGINNAME)).text(entry.getKey())).end();
                ((CMSOAPWriter)((CMSOAPWriter)wrt.element(TAG_PLUGINVERSION)).text(entry.getValue())).end();
                wrt.end();
            }
            wrt.end();
        }
        wrt.end();
    }

    private void writeContentRecord(CMSOAPWriter wrt, String tag, ArrayList<DeploymentContent> content) {
        wrt.element(tag);
        for (DeploymentContent item : content) {
            wrt.element("item");
            item.writeTo(wrt);
            wrt.end();
        }
        wrt.end();
    }

    public void loadFrom(InputStream is, CMObjectClasses classes) throws Exception {
        XMLDocParser parser = new XMLDocParser(true);
        XMLElement root = parser.readXML(is).getRootXMLElement();
        String value = root.getChildValueWithName("archiveVersion");
        this.setArchiveVersion(Integer.parseInt(value));
        value = root.getChildValueWithName("cmBuildNumber");
        this.setBuildVersion(this.parseVersion(value));
        value = root.getOptionalChildValueWithName("edition");
        this.setEdition(C8Edition.get(value));
        this.loadPlugins(root.getOptionalChildWithName(TAG_PLUGINS));
        XMLElement content = root.getOptionalChildWithName(TAG_EXPORTEDPACKAGES);
        this.loadContentRecords(content, classes, true);
        content = root.getOptionalChildWithName(TAG_EXPORTEDACCOUNTS);
        this.loadContentRecords(content, classes, false);
    }

    private void loadPlugins(XMLElement pluginsEl) throws CMException {
        if (pluginsEl == null || !pluginsEl.hasChildren()) {
            return;
        }
        this.plugins = new HashMap<String, String>(50);
        for (XMLElement el : pluginsEl.getChildren()) {
            String name = el.getChildValueWithName(TAG_PLUGINNAME);
            String version = el.getChildValueWithName(TAG_PLUGINVERSION);
            this.plugins.put(name, version);
        }
    }

    private void loadContentRecords(XMLElement root, CMObjectClasses classes, boolean isPackages) throws CMException {
        if (root == null || !root.hasChildren()) {
            return;
        }
        ArrayList<DeploymentContent> list = isPackages ? this.packages : this.accounts;
        for (XMLElement el : root.getChildren()) {
            DeploymentContent cRec = new DeploymentContent();
            cRec.loadFrom(el, classes);
            list.add(cRec);
        }
    }

    private void setEdition(C8Edition edition) {
        if (edition == null) {
            edition = C8Edition.ENTERPRISE;
        }
        this.edition = edition;
    }

    private void setBuildVersion(CMBuildVersion cmVersion) throws CMException {
        if (cmVersion.compareTo(ARCHIVE_CUTOFF_VERSION) < 0) {
            throw new CMException("cmArchiveTooOld", new CMException.Parm("Store", ARCHIVE_CUTOFF_VERSION.toString()));
        }
        if (cmVersion.compareTo(this.parseVersion(this.cmBuildVersion)) > 0) {
            throw new CMException("cmArchiveTooNew");
        }
        this.cmBuildVersion = cmVersion.toString();
    }

    private void setArchiveVersion(int version) throws CMException {
        if (version != this.archiveVersion) {
            if (version > this.archiveVersion) {
                throw new CMException("cmArchiveTooNew");
            }
            if (version < 4) {
                throw new CMException("cmArchiveTooOld", new CMException.Parm("Store", ARCHIVE_CUTOFF_VERSION.toString()));
            }
        }
        this.archiveVersion = version;
    }

    private CMBuildVersion parseVersion(String s) {
        try {
            return new CMBuildVersion(s);
        }
        catch (Exception e) {
            return new CMBuildVersion(999999, 0, 0, 0);
        }
    }
}

