/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multipart.Base64;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;

public class CredentialsDecrypter
implements Function<String, String> {
    private EncryptingSession es;

    public CredentialsDecrypter(EncryptingSession es) {
        this.es = es;
    }

    public String decrypt(String value) throws CMException, CAMCryptoException {
        if (StringUtils.isEmpty((String)value)) {
            return value;
        }
        XMLElement root = XMLDocParser.parseXml(value);
        if (!root.nameIs("credential")) {
            return value;
        }
        String s = root.getOptionalChildValueWithName("encryptedValue");
        if (s == null) {
            return value;
        }
        byte[] encryptedData = Base64.decode(s);
        byte[] decryptedData = this.es.decryptData(encryptedData);
        return Base64.encode(decryptedData);
    }

    @Override
    public String apply(String value) {
        try {
            return this.decrypt(value);
        }
        catch (Exception e) {
            CMIndications.logException(e);
            return value;
        }
    }
}

