/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multipart.Base64;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

public class CredentialsEncrypter
implements Function<String, String> {
    private EncryptingSession es;

    public CredentialsEncrypter(EncryptingSession es) {
        this.es = es;
    }

    public String encrypt(String value) throws CMException, CAMCryptoException {
        if (value == null) {
            return value;
        }
        byte[] decryptedData = null;
        if (!value.trim().startsWith("<")) {
            decryptedData = Base64.decode(value);
        } else {
            XMLElement root = XMLDocParser.parseXml(value);
            if (root.nameIs("credential") ? root.getOptionalChildWithName("encryptedValue") != null : !root.nameIs("credentials")) {
                return value;
            }
            decryptedData = value.getBytes(StandardCharsets.UTF_8);
        }
        byte[] encryptedData = this.es.encryptData(decryptedData);
        String encodedData = Base64.encode(encryptedData);
        return "<credential><encryptedValue>" + encodedData + "</encryptedValue></credential>";
    }

    @Override
    public String apply(String s) {
        try {
            return this.encrypt(s);
        }
        catch (Exception e) {
            CMIndications.logException(e);
            return s;
        }
    }
}

