/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.cm.deployment.DeploymentAncestor;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.MultilingualProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMSOAPWriter;
import java.util.ArrayList;

public class DeploymentContent {
    private static final String TAG_NAMESPACE = "namespace";
    private static final String TAG_FILENAME = "filename";
    private static final String TAG_NAMESPACEFORMAT = "namespaceFormat";
    private static final String TAG_ANCESTORS = "ancestors";
    private static final String TAG_NAME = "name";
    private static final String TAG_SEARCHPATH = "searchPath";
    private static final String TAG_OBJECTCLASS = "objectClass";
    public String filename;
    public String namespacePath;
    public int namespaceFormat;
    public CMLocalizedStringArray name;
    public CMObjectClass objClass;
    public String searchPath;
    public ArrayList<DeploymentAncestor> ancestors;
    public String storeID;

    public boolean matchesName(String name) {
        for (int i = this.name.getSize() - 1; i >= 0; --i) {
            if (!this.name.get(i).getValue().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void writeTo(CMSOAPWriter wrt) {
        ((CMSOAPWriter)((CMSOAPWriter)wrt.element(TAG_FILENAME)).text(this.filename)).end();
        if (this.namespacePath != null) {
            ((CMSOAPWriter)((CMSOAPWriter)wrt.element(TAG_NAMESPACE)).text(this.namespacePath)).end();
        }
        if (this.namespaceFormat > 0) {
            ((CMSOAPWriter)((CMSOAPWriter)wrt.element(TAG_NAMESPACEFORMAT)).text(String.valueOf(this.namespaceFormat))).end();
        }
        if (this.searchPath != null) {
            ((CMSOAPWriter)((CMSOAPWriter)wrt.element(TAG_SEARCHPATH)).text(this.searchPath)).end();
        }
        if (this.objClass != null) {
            ((CMSOAPWriter)((CMSOAPWriter)wrt.element(TAG_OBJECTCLASS)).rawText(this.objClass.getName())).end();
        }
        if (this.name != null) {
            wrt.element(TAG_NAME);
            this.name.writeTo(wrt, null);
            wrt.end();
        }
        if (this.ancestors != null) {
            wrt.element(TAG_ANCESTORS);
            for (DeploymentAncestor item : this.ancestors) {
                wrt.element("item");
                item.writeTo(wrt);
                wrt.end();
            }
            wrt.end();
        }
    }

    public void loadFrom(XMLElement el, CMObjectClasses classes) throws CMException {
        XMLElement elAncestors;
        XMLElement elName;
        this.filename = el.getChildNonNullValueWithName(TAG_FILENAME);
        this.namespacePath = el.getOptionalChildValueWithName(TAG_NAMESPACE);
        this.namespaceFormat = el.getOptionalChildIntValueWithName(TAG_NAMESPACEFORMAT, -1);
        this.searchPath = el.getOptionalChildValueWithName(TAG_SEARCHPATH);
        String value = el.getOptionalChildValueWithName(TAG_OBJECTCLASS);
        if (value != null) {
            this.objClass = classes.getClassByName(value);
        }
        if ((elName = el.getOptionalChildWithName(TAG_NAME)) != null) {
            this.name = MultilingualProperty.readTokenWithLocaleMapping(elName);
        }
        if ((elAncestors = el.getOptionalChildWithName(TAG_ANCESTORS)) != null && elAncestors.hasChildren()) {
            this.ancestors = new ArrayList();
            for (XMLElement item : elAncestors.getChildren()) {
                DeploymentAncestor da = new DeploymentAncestor();
                da.loadFrom(item);
                this.ancestors.add(da);
            }
        }
    }

    public boolean isUserContent() {
        return this.objClass == CMObjectClass.NAMESPACE || this.objClass == CMObjectClass.NAMESPACEFOLDER || this.objClass == CMObjectClass.ACCOUNT;
    }
}

