/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.cm.server.AdvancedSettings;
import java.util.ArrayList;
import java.util.List;

public class DeploymentExecutionContext
implements Cloneable {
    private static ThreadLocal<DeploymentExecutionContext> threadLocal = new ThreadLocal<DeploymentExecutionContext>(){

        @Override
        protected DeploymentExecutionContext initialValue() {
            return new DeploymentExecutionContext();
        }
    };
    private boolean includeReportOutputVersions;
    private boolean isMultiTenantDeployment;
    private boolean excludePublicUser;
    private boolean isInvalidContainmentObjRepairedAndImported;
    private List<String> tenantIDStrList;
    private int[] tenantIDIntList;

    public static DeploymentExecutionContext get() {
        return threadLocal.get();
    }

    public static void clear() {
        threadLocal.remove();
    }

    public static void set(DeploymentExecutionContext context) {
        threadLocal.set(context);
    }

    public Object clone() {
        try {
            DeploymentExecutionContext ctx = (DeploymentExecutionContext)super.clone();
            if (this.tenantIDStrList != null) {
                ctx.tenantIDStrList = new ArrayList<String>(this.tenantIDStrList);
            }
            if (this.tenantIDIntList != null) {
                ctx.tenantIDIntList = (int[])this.tenantIDIntList.clone();
            }
            return ctx;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isMultiTenantDeployment() {
        return this.isMultiTenantDeployment;
    }

    public boolean isIncludeReportOutputVersions() {
        return this.includeReportOutputVersions;
    }

    public void setIncludeReportOutputVersions(boolean includeReportOutputVersions) {
        this.includeReportOutputVersions = includeReportOutputVersions;
    }

    public boolean doExcludePublicUserAccounts() {
        return this.isMultiTenantDeployment && (!this.tenantIDStrList.contains("") || this.excludePublicUser);
    }

    public boolean doExcludePublicObjects() {
        return this.isMultiTenantDeployment && !this.tenantIDStrList.contains("");
    }

    public boolean hasInvalidContainmentObject() {
        return this.isInvalidContainmentObjRepairedAndImported;
    }

    public void setInvalidContainmentObject(boolean flag) {
        this.isInvalidContainmentObjRepairedAndImported = flag;
    }

    public void setMultiTenantDeployment(boolean isMultiTenantDeployment) {
        this.isMultiTenantDeployment = isMultiTenantDeployment;
        if (AdvancedSettings.TENANTS_DEPLOYMENT_EXCLUDE_PUBLIC_USER_ACCOUNTS) {
            this.excludePublicUser = true;
        }
    }

    public List<String> getTenantIDStrList() {
        return this.tenantIDStrList;
    }

    public void setTenantIDStrList(List<String> tenantIDStrList) {
        this.tenantIDStrList = tenantIDStrList;
    }

    public int[] getTenantIDIntList() {
        return this.tenantIDIntList;
    }

    public void setTenantIDIntList(int[] tenantIDIntList) {
        this.tenantIDIntList = tenantIDIntList;
    }
}

