/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.DeploymentCipherStreamSession;
import com.cognos.cm.request.Deployment;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.util.MultiVolumeZipOutputStream;
import com.cognos.cmutils.tempcache.CMTempFileFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.zip.ZipEntry;

public class DeploymentExportArchive {
    private static final boolean debugIgnorePassword_ = false;
    private String archiveName_;
    private File archiveFile_;
    private DeploymentCipherStreamSession cipherSession_;
    private boolean deletingArchive_;
    private MultiVolumeZipOutputStream zipStream_;
    private LinkedList<Entry> entries_;
    private Entry zipEntry_;

    public DeploymentExportArchive(String name, byte[] password, boolean overwrite) throws CMException {
        block13: {
            this.archiveName_ = name;
            this.entries_ = new LinkedList();
            File deploymentFolder = Deployment.getDeploymentFolder();
            this.archiveFile_ = new File(deploymentFolder, this.archiveName_ + ".zip");
            if (this.archiveFile_.exists()) {
                if (!overwrite) {
                    throw new CMException("cmArchiveExists", new CMException.Parm("Archive", this.archiveName_));
                }
                try {
                    if (!MultiVolumeZipOutputStream.deleteAllVolumes(this.archiveFile_)) {
                        throw new CMException("cmArchiveOverwriteError", new CMException.Parm("Archive", this.archiveName_));
                    }
                    break block13;
                }
                catch (SecurityException ex) {
                    throw new CMException((Exception)ex, "cmArchiveOverwriteError", new CMException.Parm("Archive", this.archiveName_));
                }
            }
            try {
                this.archiveFile_.createNewFile();
            }
            catch (IOException ex) {
                throw new CMException((Exception)ex, "cmArchiveCreateError", new CMException.Parm("Archive", this.archiveName_));
            }
        }
        if (password != null) {
            try {
                this.cipherSession_ = CMServlet.CAMFactory_.createDeploymentCipherStreamSession(password);
            }
            catch (CAMCryptoException e) {
                throw new CMException((Exception)((Object)e), "cmArchiveCreateError", new CMException.Parm("Archive", this.archiveName_));
            }
        }
        try {
            this.zipStream_ = new MultiVolumeZipOutputStream(this.archiveFile_);
            long volSize = AdvancedSettings.DEPLOYMENTVOLUMESIZE;
            if (volSize < 1L || volSize > 2047L) {
                volSize = 2047L;
            }
            this.zipStream_.setVolumeSize(volSize * 1024L * 1024L);
        }
        catch (Exception e) {
            throw new CMException(e, "cmArchiveCreateError", new CMException.Parm("Archive", this.archiveName_));
        }
    }

    public PrintWriter openXMLStream(String name, boolean hasData) throws CMException {
        Entry entry = this.openEntry(name, "", true, hasData);
        OutputStream os = (OutputStream)entry.stream_;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.write("<?xml version='1.0' encoding='UTF-8'?>\r\n");
            entry.stream_ = writer;
        }
        catch (IOException e) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new CMException(e, "cmExportDataWriteFail");
        }
        return writer;
    }

    public OutputStream openDataStream(String name, boolean compress) throws CMException {
        Entry entry = this.openEntry(name, "data/", compress, false);
        return (OutputStream)entry.stream_;
    }

    public OutputStream openStream(String path, String name, boolean compress) throws CMException {
        Entry entry = this.openEntry(name, path, compress, false);
        return (OutputStream)entry.stream_;
    }

    public void close() throws CMException {
        if (this.zipStream_ == null) {
            return;
        }
        try {
            if (this.zipEntry_ != null) {
                this.closeEntryStream(this.zipEntry_);
            }
            while (this.entries_.size() != 0) {
                Entry en = this.entries_.getFirst();
                if (en.stream_ == null) continue;
                this.closeEntryStream(en);
            }
            this.entries_ = null;
            this.zipStream_.close();
            this.zipStream_ = null;
        }
        catch (IOException ex) {
            throw new CMException(ex, "cmExportDataWriteFail");
        }
    }

    public void delete() {
        this.deletingArchive_ = true;
        if (this.entries_ != null) {
            this.zipEntry_ = null;
            while (this.entries_.size() != 0) {
                Entry en = this.entries_.getFirst();
                if (en.stream_ != null) {
                    try {
                        this.closeEntryStream(en);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (en.tempFile_ == null) continue;
                en.tempFile_.delete();
                this.entries_.remove(en);
            }
            this.entries_ = null;
        }
        if (this.zipStream_ != null) {
            try {
                this.zipStream_.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            MultiVolumeZipOutputStream.deleteAllVolumes(this.archiveFile_);
            this.zipStream_ = null;
        }
    }

    private Entry openEntry(String name, String folder, boolean compress, boolean temp) throws CMException {
        Entry entry = new Entry();
        entry.name_ = name;
        entry.compress_ = compress;
        entry.folder = folder;
        OutputStream os = null;
        try {
            if (this.zipEntry_ != null || temp) {
                os = this.createTempStream(entry);
            } else {
                this.addZipEntry(entry);
                os = new ExportStream(this.zipStream_, entry);
                if (this.cipherSession_ != null) {
                    os = this.cipherSession_.createEncryptingOutputStream(os);
                }
            }
        }
        catch (Exception e) {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new CMException(e, "cmExportDataWriteFail");
        }
        entry.stream_ = os;
        this.entries_.addFirst(entry);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream createTempStream(Entry entry) throws IOException, CAMCryptoException {
        OutputStream os = null;
        boolean failed = true;
        try {
            entry.tempFile_ = File.createTempFile("cmexp_", null, CMServlet.getTempFileDir());
            if (this.cipherSession_ != null) {
                os = new FileOutputStream(entry.tempFile_);
                os = new BufferedOutputStream(os, 32768);
                os = this.cipherSession_.createEncryptingOutputStream(os);
            } else {
                CMTempFileFactory tempFileFactory = CMTempFileFactory.getInstance();
                os = tempFileFactory.getOutputStream(entry.tempFile_);
            }
            os = new ExportStream(os, entry);
            failed = false;
        }
        finally {
            if (failed) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
                if (entry.tempFile_ != null) {
                    entry.tempFile_.delete();
                    entry.tempFile_ = null;
                }
            }
        }
        return os;
    }

    private void addZipEntry(Entry entry) throws IOException {
        String name = entry.folder + entry.name_;
        if (this.cipherSession_ != null) {
            name = name + "Encrypt";
        }
        ZipEntry ze = new ZipEntry(name);
        if (entry.compress_ && this.cipherSession_ == null) {
            this.zipStream_.setLevel(-1);
        } else {
            this.zipStream_.setLevel(0);
        }
        this.zipStream_.putNextEntry(ze);
        this.zipEntry_ = entry;
    }

    private void closeEntryStream(Entry entry) throws IOException {
        if (entry.stream_ != null) {
            if (entry.stream_ instanceof OutputStream) {
                ((OutputStream)entry.stream_).close();
            } else {
                ((PrintWriter)entry.stream_).close();
            }
        }
    }

    private void closeEntry(Entry entry) throws IOException {
        entry.stream_ = null;
        if (entry == this.zipEntry_) {
            this.zipStream_.closeEntry();
            this.entries_.remove(entry);
            this.zipEntry_ = null;
        }
        if (this.zipEntry_ == null) {
            ListIterator<Entry> it = this.entries_.listIterator(0);
            while (it.hasNext()) {
                Entry ent = it.next();
                if (ent.stream_ != null) continue;
                this.zipTempFile(ent);
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipTempFile(Entry entry) throws IOException {
        if (entry.tempFile_ != null) {
            InputStream is = null;
            try {
                if (!this.deletingArchive_) {
                    int numRead;
                    if (this.cipherSession_ != null) {
                        is = new FileInputStream(entry.tempFile_);
                    } else {
                        CMTempFileFactory tempFileFactory = CMTempFileFactory.getInstance();
                        is = tempFileFactory.getInputStream(entry.tempFile_);
                    }
                    this.addZipEntry(entry);
                    byte[] buffer = new byte[32768];
                    while ((numRead = is.read(buffer, 0, buffer.length)) >= 0) {
                        if (numRead == 0) continue;
                        this.zipStream_.write(buffer, 0, numRead);
                    }
                    this.zipStream_.closeEntry();
                }
            }
            finally {
                this.zipEntry_ = null;
                if (is != null) {
                    is.close();
                }
                entry.tempFile_.delete();
                entry.tempFile_ = null;
            }
        }
    }

    static class Entry {
        String name_;
        File tempFile_;
        String folder;
        boolean compress_;
        Object stream_;

        Entry() {
        }
    }

    class ExportStream
    extends FilterOutputStream {
        Entry entry_;

        ExportStream(OutputStream out, Entry entry) {
            super(out);
            this.entry_ = entry;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void close() throws IOException {
            if (this.entry_.tempFile_ != null) {
                super.close();
            }
            DeploymentExportArchive.this.closeEntry(this.entry_);
        }
    }
}

