/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreFaultDetailArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMBasePropertyValue;
import com.cognos.cm.properties.CMFaultDetailArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMString;
import com.cognos.cm.request.Deployment;
import com.cognos.cm.server.CMDataUpgradeException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreDuplicateObject;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStorePathFactory;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cmutils.xml.XMLUtils;
import java.util.ArrayList;

public class DeploymentHistory {
    private static final String XSI_TYPE = CMSOAPConstants.NS_XMLSCHEMAINSTANCE.getPrefix() + ":type=\"";
    private static final String XSD = CMSOAPConstants.NS_XMLSCHEMA.getPrefix();
    private static final String SOAP_ENC = CMSOAPConstants.NS_SOAP_ENC.getPrefix();
    private static final String CM_PREFIX = "cm";
    private static final String DEPLOYMESSAGETYPE_ERROR = "error";
    private static final String DEPLOYMESSAGETYPE_WARNING = "warning";
    private static final String DEPLOYMESSAGETYPE_INFORMATION = "information";
    private static final String DeployMessageItem1 = "<item " + XSI_TYPE + "cm" + ":faultDetail\">\r\n";
    private static final String DeployMessageErrorCode = "\t<errorCode " + XSI_TYPE + XSD + ":string\">";
    private static final String DeployMessageErrorCodePost = "</errorCode>\r\n";
    private static final String DeployMessageMessageArray = "\t<message " + XSI_TYPE + SOAP_ENC + ":Array\" " + SOAP_ENC + ":arrayType=\"" + "cm" + ":faultDetailMessage[";
    private static final String DeployMessageMessageArrayPost = "]\">\r\n";
    private static final String DeployMessageMessage = "\t\t\t<message " + XSI_TYPE + XSD + ":string\">";
    private static final String DeployMessageMessagePost = "</message>\r\n";
    private static final String DeployMessageNesting = "\t\t\t<nestingLevel " + XSI_TYPE + XSD + ":int\">";
    private static final String DeployMessageNestingPost = "</nestingLevel>\r\n";
    private static final String DeployMessageItem2 = "\t\t<item " + XSI_TYPE + "cm" + ":faultDetailMessage\">\r\n";
    private static final String DeployMessageItem2End = "\t\t</item>\r\n";
    private static final String DeployMessageSeverity = "\t<severity " + XSI_TYPE + XSD + ":string\">";
    private static final String DeployMessageSeverityPost = "</severity>\r\n";
    private static final String DeployMessageMessageArrayEnd = "\t</message>\r\n";
    private static final String DeployMessageItem1End = "</item>\r\n";
    private static final String rootObjSearchPathSuffix_ = CMObjectClass.ROOT.getName() + "[@name='" + "/" + "']";
    private int rootDetailId_ = -1;
    private ICMLockManager lockMgr_;
    private CMStore store_;
    private Deployment requestHandler;
    private boolean isExport_;
    private String addDetailPath_ = null;
    private int maxDetailSeverity_ = -1;
    private String spRunHistory_;
    private CMStorePath spRunHistoryStorePath_ = null;
    private ArrayList<SaveDeploymentDetail> saveDetailList_ = null;

    public DeploymentHistory(Deployment requestHandler, String runHistoryPath, boolean isExport) throws CMException {
        this(requestHandler, runHistoryPath, isExport, new CMStorePathFactory());
    }

    protected DeploymentHistory(Deployment requestHandler, String runHistoryPath, boolean isExport, CMStorePathFactory pathFactory) throws CMException {
        this.requestHandler = requestHandler;
        this.spRunHistory_ = runHistoryPath;
        this.spRunHistoryStorePath_ = pathFactory.parse(this.spRunHistory_);
        this.store_ = requestHandler.getStore();
        this.lockMgr_ = this.store_.getLockManager();
        this.isExport_ = isExport;
    }

    public int getMaxDetailSeverity() {
        return this.maxDetailSeverity_;
    }

    protected void setHistoryStatus(ArrayList<CMProperty> propNames, ArrayList<Object> propValues, boolean success) {
        propNames.add(CMProperty.STATUS);
        propValues.add(success ? "succeeded" : "failed");
    }

    protected void setActualCompletionTime(ArrayList<CMProperty> propNames, ArrayList<Object> propValues) {
        String now = CMDateUtils.getIsoDate();
        propNames.add(CMProperty.ACTUALCOMPLETIONTIME);
        propValues.add(now);
    }

    private void lockHistory(int usage) throws CMException {
        this.spRunHistoryStorePath_.clearLocksHaveBeenObtained();
        this.spRunHistoryStorePath_.setLockManagerUsageFlag(usage);
        this.lockMgr_.requestLocks(this.spRunHistoryStorePath_);
    }

    private void rollbackOpenTransaction() {
        if (this.store_.inTransaction()) {
            try {
                this.store_.rollbackTransaction();
            }
            catch (CMException ex) {
                CMIndications.logException(ex);
            }
        }
    }

    private void releaseLocks() {
        try {
            this.lockMgr_.releaseLocks();
        }
        catch (Exception e) {
            CMIndications.logException(e);
        }
    }

    private static String formatErrors(CMException exception) {
        String messageType = DEPLOYMESSAGETYPE_ERROR;
        if (exception.ErrorLevel == 30000) {
            messageType = DEPLOYMESSAGETYPE_WARNING;
        } else if (exception.ErrorLevel < 30000) {
            messageType = DEPLOYMESSAGETYPE_INFORMATION;
        }
        Exception ex = exception;
        int count = 0;
        while (ex != null) {
            if (ex instanceof CMException) {
                CMException cmex = ex;
                ex = cmex.getException();
            } else {
                ex = null;
            }
            ++count;
        }
        StringBuffer errorBuf = new StringBuffer(512);
        errorBuf.append(DeployMessageItem1);
        errorBuf.append(DeployMessageErrorCode);
        errorBuf.append(exception.getCode());
        errorBuf.append(DeployMessageErrorCodePost);
        errorBuf.append(DeployMessageMessageArray);
        errorBuf.append(String.valueOf(count));
        errorBuf.append(DeployMessageMessageArrayPost);
        ex = exception;
        int nesting = 0;
        while (ex != null) {
            String message = exception.getLocalizedMessage(ex);
            errorBuf.append(DeployMessageItem2);
            errorBuf.append(DeployMessageMessage);
            errorBuf.append(XMLUtils.escape((String)message));
            errorBuf.append(DeployMessageMessagePost);
            errorBuf.append(DeployMessageNesting);
            errorBuf.append(String.valueOf(nesting));
            errorBuf.append(DeployMessageNestingPost);
            errorBuf.append(DeployMessageItem2End);
            if (ex instanceof CMException) {
                Exception cmex = ex;
                ex = ((CMException)cmex).getException();
            } else {
                ex = null;
            }
            ++nesting;
        }
        errorBuf.append(DeployMessageMessageArrayEnd);
        errorBuf.append(DeployMessageSeverity);
        errorBuf.append(messageType);
        errorBuf.append(DeployMessageSeverityPost);
        errorBuf.append(DeployMessageItem1End);
        String errorXML = errorBuf.toString();
        return errorXML;
    }

    public void addRootDetail(Throwable error) {
        if (this.requestHandler.isRequestCancelled()) {
            return;
        }
        if (error == null) {
            throw new IllegalArgumentException();
        }
        String code = this.isExport_ ? "cmExportFailed" : "cmImportFailed";
        CMException ex = error instanceof CMException ? new CMException((CMException)error, code) : new CMException(error, code);
        this.addErrorDetail("/", 7, ex);
    }

    public void addRootError(CMException ex) {
        if (ex == null) {
            throw new IllegalArgumentException();
        }
        this.addErrorDetail("/", 7, ex);
    }

    public void addRootWarning(CMException ex) {
        ex.ErrorLevel = 30000;
        this.addErrorDetail("/", 7, ex);
    }

    public void addRootDetail(int numDeployed, int numFailed) {
        if (this.requestHandler.isRequestCancelled()) {
            return;
        }
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("number1", Integer.toString(numDeployed)), new CMException.Parm("number2", Integer.toString(numFailed))};
        String code = this.isExport_ ? "cmInfoDeploymentHistoryExport" : "cmInfoDeploymentHistoryImport";
        CMException infoEx = new CMException(code, parms);
        infoEx.ErrorLevel = 20000;
        this.addErrorDetail("/", -1, infoEx);
    }

    public void addRootDetailObsoleteSetting() {
        if (this.requestHandler.isRequestCancelled()) {
            return;
        }
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("OldSetting", "CM.TENANTS_DEPLOYMENT_UPDATE_TARGET"), new CMException.Parm("NewSetting", "tenantsContentConflictResolution")};
        CMException infoEx = new CMException("cmInfoDeploymentObsoleteSetting", parms);
        infoEx.ErrorLevel = 20000;
        this.addErrorDetail("/", -1, infoEx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHistory(ArrayList<CMProperty> propNames, ArrayList<Object> propValues) {
        CMStoreQueryResults results = null;
        try {
            this.lockHistory(13);
            this.store_.beginTransaction();
            results = this.store_.executeQuery(this.spRunHistoryStorePath_, null, null, 7, 2, null);
            if (!results.next()) {
                throw new CMException("cmMissingDeployRunHistory", new CMException.Parm("Path", CMQueryUtils.getPath(this.store_, this.spRunHistory_)));
            }
            results.reset();
            this.store_.update(results, propNames, propValues);
            this.store_.commitTransaction();
        }
        catch (Exception ex) {
            CMIndications.logException(new CMException(ex, "cmFailedUpdateDeployStatus"));
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.rollbackOpenTransaction();
            this.releaseLocks();
        }
    }

    public void updateRunHistory(boolean success) {
        if (CMIndicationGlobals.bDEP_Info_isEnabled) {
            CMIndications.CMTrace("cmDeployUpdateHistory", new CMException.Parm("file", this.spRunHistory_));
        }
        ArrayList<CMProperty> propNames = new ArrayList<CMProperty>();
        ArrayList<Object> propValues = new ArrayList<Object>();
        this.setActualCompletionTime(propNames, propValues);
        this.setHistoryStatus(propNames, propValues, success);
        if (this.maxDetailSeverity_ > 0) {
            propNames.add(CMProperty.MAXIMUMDETAILSEVERITY);
            propValues.add(CMDataUpgradeUtils.convertIPFLevelToSeverityEnum(this.maxDetailSeverity_));
        }
        if (!propNames.isEmpty()) {
            this.updateHistory(propNames, propValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addErrorDetail(String searchPath, int statusDeploy, CMException errors) {
        if (this.requestHandler.isRequestCancelled()) {
            return;
        }
        if (searchPath == "/") {
            if (this.rootDetailId_ != -1) {
                this.updateDetail(searchPath, this.rootDetailId_, statusDeploy, errors);
                return;
            }
            if (statusDeploy == -1) {
                statusDeploy = this.isExport_ ? 6 : 3;
            }
        }
        try {
            CMAncestors ancestors;
            CMBasePropertyValue objectName;
            String strName;
            CMObjectClass objClass;
            String strPath;
            block13: {
                CMStoreQueryResults results;
                block14: {
                    this.lockHistory(11);
                    this.store_.beginTransaction();
                    strPath = null;
                    objClass = null;
                    strName = null;
                    objectName = null;
                    ancestors = null;
                    results = null;
                    CMStoreXPath queryPath = new CMStoreXPath(searchPath);
                    try {
                        CMProperty[] props = new CMProperty[]{CMProperty.ANCESTORS, CMProperty.DEFAULTNAME, CMProperty.NAME};
                        results = this.store_.executeQuery(queryPath, props, null, 9, 512, null);
                        if (results.next()) {
                            strPath = results.getSearchPath();
                            objClass = results.getObjectClass();
                            ancestors = (CMAncestors)results.getValue(0);
                            strName = results.getValue(1).toString();
                            objectName = (CMBasePropertyValue)results.getValue(2);
                            if (results == null) break block13;
                            break block14;
                        }
                        throw new CMException("cmDeployQueryDetailMatchFailed", new CMException.Parm("path", searchPath));
                    }
                    catch (Throwable throwable) {
                        if (results == null) throw throwable;
                        CMQueryUtils.safeQueryResultsRelease(results);
                        throw throwable;
                    }
                }
                CMQueryUtils.safeQueryResultsRelease(results);
            }
            int objId = this.addDetail(strPath, 0, objClass, strName, objectName, ancestors, statusDeploy, errors, false);
            this.store_.commitTransaction();
            if (searchPath != "/") return;
            if (objId == -1) return;
            this.rootDetailId_ = objId;
            return;
        }
        catch (Exception e) {
            if (errors != null) {
                CMIndications.logException(errors);
            }
            CMIndications.logException(new CMException(e, "cmErrorDeploymentDetail2", new CMException.Parm("path", searchPath)));
            return;
        }
        finally {
            this.rollbackOpenTransaction();
            this.releaseLocks();
        }
    }

    public void saveDetail(int id, int statusDeploy, CMException errors) {
        if (this.saveDetailList_ == null) {
            this.saveDetailList_ = new ArrayList();
        }
        SaveDeploymentDetail detail = new SaveDeploymentDetail();
        detail.id = id;
        detail.statusDeploy = statusDeploy;
        detail.errors = errors;
        this.saveDetailList_.add(detail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSavedDetails() {
        if (this.requestHandler.isRequestCancelled()) {
            return;
        }
        if (this.saveDetailList_ == null) {
            return;
        }
        int lastCommited = -1;
        try {
            this.lockHistory(11);
            int transactionCounter = 0;
            this.store_.beginTransaction();
            int size = this.saveDetailList_.size();
            int parentDetailId = -1;
            for (int i = 0; i < size; ++i) {
                CMAncestors ancestors;
                CMBasePropertyValue objectName;
                String strName;
                CMObjectClass objClass;
                String strPath;
                SaveDeploymentDetail detail;
                block18: {
                    detail = this.saveDetailList_.get(i);
                    int[] object_ids = new int[]{detail.id};
                    ++transactionCounter;
                    strPath = null;
                    objClass = null;
                    strName = null;
                    objectName = null;
                    ancestors = null;
                    CMStoreQueryResults results = null;
                    try {
                        CMProperty[] props = new CMProperty[]{CMProperty.ANCESTORS, CMProperty.DEFAULTNAME, CMProperty.NAME};
                        results = this.store_.executeQuery(object_ids, props, null, 9, 512, null);
                        if (!results.next()) {
                            throw new CMException("cmDeployQueryDetailMatchFailed", new CMException.Parm("path", CMQueryUtils.getPath(this.store_, "id=" + String.valueOf(detail.id))));
                        }
                        strPath = results.getSearchPath();
                        objClass = results.getObjectClass();
                        ancestors = (CMAncestors)results.getValue(0);
                        strName = results.getValue(1).toString();
                        objectName = (CMBasePropertyValue)results.getValue(2);
                        if (results == null) break block18;
                    }
                    catch (CMException ex) {
                        try {
                            throw new CMException((Exception)ex, "cmDeployQueryDetailMatchFailed", new CMException.Parm("path", CMQueryUtils.getPath(this.store_, "id=" + String.valueOf(detail.id))));
                        }
                        catch (Throwable throwable) {
                            if (results == null) throw throwable;
                            CMQueryUtils.safeQueryResultsRelease(results);
                            throw throwable;
                        }
                    }
                    CMQueryUtils.safeQueryResultsRelease(results);
                }
                if (parentDetailId < 0) {
                    parentDetailId = this.addDetail(strPath, 0, objClass, strName, objectName, ancestors, detail.statusDeploy, detail.errors, true);
                } else {
                    this.createDetailObject(parentDetailId, strPath, objClass, strName, objectName, ancestors, detail.statusDeploy, detail.errors);
                }
                if (transactionCounter <= 50) continue;
                this.store_.commitTransaction();
                transactionCounter = 0;
                lastCommited = i;
                this.store_.beginTransaction();
            }
            this.store_.commitTransaction();
            return;
        }
        catch (Exception e) {
            int i = lastCommited + 1;
            while (true) {
                if (i >= this.saveDetailList_.size()) {
                    CMIndications.logException(new CMException(e, "cmErrorDeploymentDetail"));
                    return;
                }
                SaveDeploymentDetail detail = this.saveDetailList_.get(i);
                if (detail.errors != null) {
                    CMIndications.logException(detail.errors);
                }
                ++i;
            }
        }
        finally {
            this.saveDetailList_ = null;
            this.rollbackOpenTransaction();
            this.releaseLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int safeAddDetail(String strPath, int parentDetailId, CMObjectClass objClass, String strName, CMBasePropertyValue objectName, CMAncestors ancestors, int statusDeploy, CMException errors, boolean returnParent) {
        int result = -1;
        CMStoreQueryResults qresults = null;
        try {
            this.lockHistory(11);
            qresults = this.store_.executeQuery(this.spRunHistoryStorePath_, null, null, 9, 1, null);
            if (qresults == null || !qresults.next()) {
                throw new CMException("cmMissingRunHistory");
            }
            result = this.addDetail(strPath, parentDetailId, objClass, strName, objectName, ancestors, statusDeploy, errors, returnParent);
        }
        catch (Exception e) {
            if (errors != null) {
                CMIndications.logException(errors);
            }
            CMIndications.logException(new CMException(e, "cmErrorDeploymentDetail2", new CMException.Parm("path", strPath)));
        }
        finally {
            if (qresults != null) {
                qresults.release();
            }
            this.releaseLocks();
        }
        return result;
    }

    private int addDetail(String strPath, int parentDetailId, CMObjectClass objClass, String strName, CMBasePropertyValue objectName, CMAncestors ancestors, int statusDeploy, CMException errors, boolean returnParent) throws CMException {
        if (this.requestHandler.isRequestCancelled()) {
            return -1;
        }
        if (strPath == null && errors != null && errors instanceof CMDataUpgradeException) {
            strPath = "/";
            String objName = ((CMDataUpgradeException)errors).getObjectName();
            if (objName != null) {
                strName = objName;
            }
        }
        if (strPath == null) {
            return -1;
        }
        this.addDetailPath_ = strPath;
        StringBuffer buf = new StringBuffer();
        String slashPath = strPath;
        if (slashPath.charAt(0) != '/') {
            if (ancestors == null && statusDeploy != 7 || objClass == null || strName == null) {
                return -1;
            }
            StringBuffer madePath = new StringBuffer();
            if (ancestors != null) {
                for (int i = 0; i < ancestors.getSize(); ++i) {
                    madePath.append('/');
                    madePath.append(ancestors.getObjectClass(i));
                    madePath.append("[@");
                    madePath.append(CMProperty.NAME.getName());
                    madePath.append("=");
                    madePath.append(CMStoreXPath.attributeQuoteString(ancestors.getName(i)));
                    madePath.append("]");
                }
            }
            madePath.append('/');
            madePath.append(objClass.getName());
            madePath.append("[@");
            madePath.append(CMProperty.NAME.getName());
            madePath.append("=");
            madePath.append(CMStoreXPath.attributeQuoteString(strName));
            madePath.append("]");
            slashPath = madePath.toString();
        }
        buf.append(this.spRunHistory_);
        buf.append(slashPath);
        if (slashPath.equals("/")) {
            buf.append(rootObjSearchPathSuffix_);
        }
        String detailPathStr = buf.toString();
        CMStorePath historyPath = CMStoreXPath.parse(this.spRunHistory_);
        CMStorePath detailPath = CMStoreXPath.parse(detailPathStr);
        CMStorePath detailPathParent = detailPath.getParent();
        for (int i = historyPath.size(); i < detailPathParent.size(); ++i) {
            detailPathParent.stepAt(i).setClass(CMObjectClass.DEPLOYMENTDETAIL);
        }
        CMStorePath objectContext = CMStoreXPath.parse(strPath);
        CMStorePath objectContextParent = null;
        try {
            objectContextParent = CMQueryUtils.getParentSearchPath(this.store_, objectContext);
        }
        catch (RuntimeException ex) {
            detailPath = CMStoreXPath.parse(this.spRunHistory_ + "/" + rootObjSearchPathSuffix_);
            detailPathParent = detailPath.getParent();
            objectContext = CMStoreXPath.parse("/");
            objectContextParent = CMQueryUtils.getParentSearchPath(this.store_, objectContext);
        }
        int objId = -1;
        try {
            if (parentDetailId < 1) {
                parentDetailId = this.ensureDetailParentExists(detailPathParent, objectContextParent);
            }
            objId = this.createDetailObject(parentDetailId, strPath, objClass, strName, objectName, ancestors, statusDeploy, errors);
        }
        catch (CMException e) {
            if (e.getCode().equals("cmDeployDetailParentMissing")) {
                buf = new StringBuffer();
                buf.append(this.spRunHistory_);
                buf.append("/");
                buf.append(rootObjSearchPathSuffix_);
                detailPathStr = buf.toString();
                detailPath = CMStoreXPath.parse(detailPathStr);
                detailPathParent = detailPath.getParent();
                objectContext = CMStoreXPath.parse("/");
                objectContextParent = null;
                try {
                    objectContextParent = CMQueryUtils.getParentSearchPath(this.store_, objectContext);
                    if (parentDetailId < 1) {
                        parentDetailId = this.ensureDetailParentExists(detailPathParent, objectContextParent);
                    }
                }
                catch (CMException ex) {
                    if (errors != null) {
                        CMIndications.logException(errors);
                    }
                    throw ex;
                }
                objId = this.createDetailObject(parentDetailId, strPath, objClass, strName, objectName, ancestors, statusDeploy, errors);
            }
            throw e;
        }
        if (returnParent) {
            return parentDetailId;
        }
        return objId;
    }

    protected void setDetailTime(ArrayList<CMProperty> propNames, ArrayList<Object> propValues) {
        String now = CMDateUtils.getIsoDate();
        propNames.add(CMProperty.DETAILTIME);
        propValues.add(now);
    }

    protected void setDetailSeverity(ArrayList<CMProperty> propNames, ArrayList<Object> propValues, CMException exception) {
        if (exception == null) {
            return;
        }
        String severity = CMDataUpgradeUtils.convertIPFLevelToSeverityEnum(exception.ErrorLevel);
        if (severity != null) {
            propNames.add(CMProperty.SEVERITY);
            propValues.add(severity);
        }
    }

    protected int createDetailObject(int obj_id, String path, CMObjectClass objClass, String strName, CMBasePropertyValue objectName, CMAncestors ancestors, int statusDeploy, CMException errors) throws CMException {
        ArrayList<CMProperty> propNames = new ArrayList<CMProperty>();
        ArrayList<Object> propValues = new ArrayList<Object>();
        if (strName.length() > 255) {
            strName = strName.substring(0, 254);
        }
        if (objectName == null) {
            objectName = new CMDbStoreString(strName);
        }
        if (objClass != null) {
            propNames.add(CMProperty.DEPLOYEDOBJECTCLASS);
            propValues.add(objClass.getName());
            propNames.add(CMProperty.DEPLOYEDOBJECTUSAGE);
            propValues.add(objClass.getUsage());
        }
        int parentTenantId = this.store_.getCache().CMCacheGetTenantID(obj_id);
        int tenantIdToUse = MultiTenancyUtils.determineTenantIdWithVirtualInheritance(parentTenantId);
        propNames.add(CMProperty.TENANTID);
        propValues.add(this.store_.getTenantRegistry().getTenantIdStringFromInt(tenantIdToUse));
        propNames.add(CMProperty.DEPLOYEDOBJECTDEFAULTNAME);
        propValues.add(strName);
        if (ancestors != null) {
            CMDbStoreStringArray dbAncestors = this.getAnscestorsNames(ancestors);
            propNames.add(CMProperty.DEPLOYEDOBJECTANCESTORDEFAULTNAMES);
            propValues.add(dbAncestors);
        }
        propNames.add(CMProperty.DEPLOYEDOBJECTSTATUS);
        propValues.add(CMSOAPConstants.DEPLOYMENTSTATUS[statusDeploy]);
        if (path != null) {
            propNames.add(CMProperty.DEPLOYEDOBJECT);
            CMDbStoreBaseClassArray baseClassArray = new CMDbStoreBaseClassArray();
            baseClassArray.add(new CMDbStoreObjectReference(path));
            propValues.add(baseClassArray);
        }
        if (errors != null) {
            propNames.add(CMProperty.MESSAGE);
            CMDbStoreFaultDetailArray faultDetailArray = new CMDbStoreFaultDetailArray(1, DeploymentHistory.formatErrors(errors));
            propValues.add(faultDetailArray);
            this.setDetailSeverity(propNames, propValues, errors);
            if (errors.ErrorLevel > this.maxDetailSeverity_) {
                this.maxDetailSeverity_ = errors.ErrorLevel;
            }
        }
        this.setDetailTime(propNames, propValues);
        boolean closeTransaction = false;
        if (!this.store_.inTransaction()) {
            this.store_.beginTransaction();
            closeTransaction = true;
        }
        CMStoreQueryResults addResult = null;
        int newObj_id = -1;
        try {
            addResult = this.store_.addObject(obj_id, objectName, CMObjectClass.DEPLOYMENTDETAIL, propNames, propValues);
            if (addResult.next()) {
                newObj_id = addResult.getObjectID();
            }
            if (closeTransaction) {
                this.store_.commitTransaction();
            }
        }
        catch (CMStoreDuplicateObject e) {
            int n = -1;
            return n;
        }
        catch (CMStoreObjectNotFound e) {
            throw new CMException("cmDeployDetailParentMissing", new CMException.Parm("path", path), new CMException.Parm("realPath", this.addDetailPath_));
        }
        finally {
            if (addResult != null) {
                addResult.release();
            }
            if (closeTransaction) {
                this.rollbackOpenTransaction();
            }
        }
        return newObj_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int ensureDetailParentExists(CMStorePath detailPathParent, CMStorePath pathRealObject) throws CMException {
        int obj_id = -1;
        CMStoreQueryResults results = null;
        try {
            results = this.store_.executeQuery(detailPathParent, null, null, 9, 1, null);
            if (results.next()) {
                obj_id = results.getObjectID();
                CMObjectClass cls = results.getObjectClass();
                if (cls != CMObjectClass.HISTORY && cls != CMObjectClass.DEPLOYMENTDETAIL) {
                    throw new CMException("cmMissingRunHistory");
                }
            }
        }
        catch (Throwable throwable) {
            CMQueryUtils.safeQueryResultsRelease(results);
            results = null;
            throw throwable;
        }
        CMQueryUtils.safeQueryResultsRelease(results);
        results = null;
        if (obj_id < 0) {
            CMBasePropertyValue objectName;
            CMAncestors ancestors;
            String strName;
            CMObjectClass objClass;
            String path;
            block18: {
                CMStorePath detailPathParentParent = detailPathParent.getParent();
                CMStorePath pathRealObjectParent = CMQueryUtils.getParentSearchPath(this.store_, pathRealObject);
                obj_id = this.ensureDetailParentExists(detailPathParentParent, pathRealObjectParent);
                path = null;
                objClass = null;
                strName = null;
                ancestors = null;
                objectName = null;
                try {
                    boolean notFound = false;
                    CMProperty[] props = new CMProperty[]{CMProperty.ANCESTORS, CMProperty.DEFAULTNAME, CMProperty.NAME};
                    results = this.store_.executeQuery(pathRealObject, props, null, 0, 512, null);
                    if (!results.next()) {
                        results.release();
                        results = this.store_.executeQuery(pathRealObject, props, null, 9, 512, null);
                        if (!results.next()) {
                            notFound = true;
                        }
                    }
                    if (notFound) {
                        throw new CMException("cmDeployDetailParentMissing", new CMException.Parm("path", pathRealObject));
                    }
                    path = results.getSearchPath();
                    objClass = results.getObjectClass();
                    ancestors = (CMAncestors)results.getValue(0);
                    strName = results.getValue(1).toString();
                    objectName = (CMBasePropertyValue)results.getValue(2);
                    if (strName != null) break block18;
                    if (path != null) {
                        strName = path;
                        break block18;
                    }
                    throw new CMException("cmDeployQueryDetailMatchFailed", new CMException.Parm("path", pathRealObject));
                }
                catch (CMException ex) {
                    if (ex.getCode().equals("cmDeployQueryDetailMatchFailed")) {
                        throw new CMException("cmDeployQueryDetailMatchFailed", new CMException.Parm("path", pathRealObject));
                    }
                    if (ex.getCode().equals("cmDeployDetailParentMissing")) {
                        throw new CMException("cmDeployDetailParentMissing", new CMException.Parm("path", pathRealObject));
                    }
                    throw new CMException((Exception)ex, "cmDeployQueryDetailMatchFailed", new CMException.Parm("path", pathRealObject));
                }
                finally {
                    if (results != null) {
                        CMQueryUtils.safeQueryResultsRelease(results);
                    }
                }
            }
            obj_id = this.createDetailObject(obj_id, path, objClass, strName, objectName, ancestors, 0, null);
            if (obj_id == -1) {
                String pathReal = CMQueryUtils.getPath(this.store_, pathRealObject);
                throw new CMException("cmDeployDetailParentFailed", new CMException.Parm("path", pathReal), new CMException.Parm("realPath", this.addDetailPath_));
            }
        }
        return obj_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDetail(String path, int detailId, int status, CMException errors) {
        if (this.requestHandler.isRequestCancelled()) {
            return;
        }
        if (errors == null) {
            throw new IllegalArgumentException("errors == null");
        }
        try {
            if (detailId < 1) {
                int errLevel = errors.ErrorLevel;
                errors = new CMException((Exception)errors, "cmProblemImportingObject1", new CMException.Parm("path", path));
                errors.ErrorLevel = errLevel;
                this.addErrorDetail("/", status, errors);
                return;
            }
            ArrayList<CMProperty> propNames = new ArrayList<CMProperty>();
            ArrayList<Object> propValues = new ArrayList<Object>();
            CMProperty[] props = null;
            if (status >= 0) {
                propNames.add(CMProperty.DEPLOYEDOBJECTSTATUS);
                propValues.add(CMSOAPConstants.DEPLOYMENTSTATUS[status]);
            }
            props = new CMProperty[]{CMProperty.MESSAGE, CMProperty.SEVERITY};
            CMStoreQueryResults results = null;
            CMStorePath detailQuery = null;
            try {
                detailQuery = CMStoreXPath.parse("ID(" + String.valueOf(detailId) + ")");
                this.store_.beginTransaction();
                results = this.store_.executeQuery(detailQuery, props, null, 0, 1, null);
                if (results.next()) {
                    int msgCount = 1;
                    String msg = DeploymentHistory.formatErrors(errors);
                    CMFaultDetailArray details = (CMFaultDetailArray)results.getValue(0);
                    if (details != null) {
                        msgCount += details.getSize();
                        msg = details.getXMLContent(CMProperty.MESSAGE) + msg;
                    }
                    details = new CMDbStoreFaultDetailArray(msgCount, msg);
                    propNames.add(CMProperty.MESSAGE);
                    propValues.add(details);
                    String severity = null;
                    CMString severityObj = (CMString)results.getValue(1);
                    if (severityObj != null) {
                        severity = severityObj.getValue();
                    }
                    int currentSeverity = -1;
                    if (severity != null) {
                        currentSeverity = CMDataUpgradeUtils.convertSeverityEnumToIPFLevel(severity);
                    }
                    if (severity == null || currentSeverity < errors.ErrorLevel) {
                        this.setDetailSeverity(propNames, propValues, errors);
                        if (errors.ErrorLevel > this.maxDetailSeverity_) {
                            this.maxDetailSeverity_ = errors.ErrorLevel;
                        }
                    }
                }
                results.reset();
                this.store_.update(results, propNames, propValues);
                this.store_.commitTransaction();
            }
            catch (Throwable throwable) {
                CMQueryUtils.safeQueryResultsRelease(results);
                this.rollbackOpenTransaction();
                throw throwable;
            }
            CMQueryUtils.safeQueryResultsRelease(results);
            this.rollbackOpenTransaction();
        }
        catch (Exception e) {
            errors.ErrorLevel = 50000;
            CMIndications.logException(errors);
            CMException e1 = new CMException(e, "cmFailedToUpdateDeployDetail", new CMException.Parm("path", path));
            e1.ErrorLevel = 40000;
            CMIndications.logException(e1);
        }
    }

    private CMDbStoreStringArray getAnscestorsNames(CMAncestors ancestors) {
        CMDbStoreStringArray anscestorNames = null;
        if (ancestors != null) {
            anscestorNames = new CMDbStoreStringArray();
            for (int i = 0; i < ancestors.getSize(); ++i) {
                anscestorNames.add(ancestors.getName(i));
            }
        }
        return anscestorNames;
    }

    private static class SaveDeploymentDetail {
        int id;
        int statusDeploy;
        CMException errors;

        private SaveDeploymentDetail() {
        }
    }
}

