/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.cm.properties.CMStringArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMDeploymentArchive;
import com.cognos.cm.util.CMStringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class HomeFolderIndex {
    private HashMap<String, int[]> lineage = new HashMap();
    private BitSet references = new BitSet();

    public void addReferences(CMStringArray references) {
        if (references == null) {
            return;
        }
        for (int i = 0; i < references.getSize(); ++i) {
            int[] line;
            String docId = references.getString(i);
            if (docId == null || docId.isEmpty() || (line = this.lineage.get(docId)) == null) continue;
            for (int id : line) {
                this.references.set(id);
            }
        }
    }

    public boolean isReferenced(int id) {
        return this.references.get(id);
    }

    public void loadFrom(CMDeploymentArchive archive) throws CMException {
        InputStream is = archive.getInputStream("homeFolders.idx");
        try {
            this.load(is);
        }
        catch (IOException e) {
            throw new CMException((Exception)e, "cmArchiveBad", new CMException.Parm("Archive", archive.getName()));
        }
    }

    protected void load(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.US_ASCII));
        while ((line = reader.readLine()) != null) {
            ArrayList<String> parts = CMStringUtils.split(line, ' ');
            int[] ids = new int[parts.size() - 1];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = Integer.parseInt(parts.get(i + 1));
            }
            this.lineage.put(parts.get(0), ids);
        }
    }
}

