/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.cm.deployment.DeploymentExportArchive;
import com.cognos.cm.deployment.exportTree.ExportEntry;
import com.cognos.cm.deployment.exportTree.HomeFolderExportTree;
import com.cognos.cm.server.CMException;
import com.cognos.cmutils.collections.TraverseOrder;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class HomeFolderIndexWriter {
    public static final String INDEX_NAME = "homeFolders.idx";
    private final HomeFolderExportTree referenceTree;

    public HomeFolderIndexWriter(HomeFolderExportTree tree) {
        this.referenceTree = tree;
    }

    public void writeTo(DeploymentExportArchive archive) throws CMException {
        Writer wrt = null;
        try {
            wrt = this.openIndexForWriting(archive);
            this.writeTo(wrt);
        }
        catch (Exception e) {
            throw new CMException(e, "cmBadOutputFile", new CMException.Parm("Filename", INDEX_NAME));
        }
        finally {
            CMStreamUtils.quietClose((Writer)wrt);
        }
    }

    void writeTo(Writer writer) throws IOException {
        for (ExportEntry entry : this.referenceTree.entries(TraverseOrder.postorder, null)) {
            if (!this.isDeployedReferenceEntry(entry)) continue;
            this.writeEntry(writer, (HomeFolderExportTree.DocumentExportEntry)entry);
        }
    }

    private void writeEntry(Writer wrt, HomeFolderExportTree.DocumentExportEntry refentry) throws IOException {
        StringBuilder buf = new StringBuilder(128);
        buf.append(refentry.getDocumentId());
        ExportEntry entry = refentry;
        while (entry.getID() != 0) {
            buf.append(" ");
            buf.append(entry.getID());
            entry = entry.getParent();
        }
        buf.append('\n');
        wrt.write(buf.toString());
    }

    private boolean isDeployedReferenceEntry(ExportEntry entry) {
        return entry.getID() != -1 && entry instanceof HomeFolderExportTree.DocumentExportEntry;
    }

    private Writer openIndexForWriting(DeploymentExportArchive archive) throws CMException {
        OutputStream os = archive.openStream("", INDEX_NAME, true);
        return new OutputStreamWriter(os, StandardCharsets.US_ASCII);
    }
}

