/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.XMLElement;
import com.cognos.cmutils.collections.FilterIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;

public abstract class OptionsCoder {
    protected static final HashSet<String> OPTIONS_WITH_CREDENTIALS = new HashSet<String>(Arrays.asList("archiveEncryptPassword", "userPassword", "ownerPassword"));
    protected static final HashSet<String> OPTIONS_WITH_OBJREFS = new HashSet<String>(Arrays.asList("genericOptionObjectRef", "genericOptionObjectRefArray"));
    protected static final String[] TYPES_WITH_PATH = new String[]{"searchPathSingleObject", "searchPathMultipleObject"};
    protected static final String[] TYPES_WITH_GUID = new String[]{"guid"};

    protected static void throwBadValue(Exception cause) throws CMException {
        throw new CMException(cause, "cmPropInvalidContent", new CMException.Parm("Property", "options"));
    }

    protected static boolean canContainCredentials(String s) {
        return OPTIONS_WITH_CREDENTIALS.contains(s);
    }

    protected static EncryptingSession createEncryptingSession() throws CMException {
        try {
            return CMServlet.CAMFactory_.createEncryptingSession();
        }
        catch (CAMCryptoException e) {
            throw new CMException((Exception)((Object)e), "cmCryptoInitFailed");
        }
    }

    protected static Iterator<XMLElement> createOptionValueIterator(XMLElement el, String ... types) {
        Iterator<XMLElement> it = el.treeIterator();
        return new FilterIterator(it, e -> OptionsCoder.matchesTypes(e, types));
    }

    protected static boolean encodeXml(Iterator<XMLElement> it, Function<String, String> coder) {
        boolean updated = false;
        while (it.hasNext()) {
            XMLElement el = it.next();
            String newValue = coder.apply(el.value_);
            if (newValue == el.value_) continue;
            el.value_ = newValue;
            updated = true;
        }
        return updated;
    }

    protected static boolean matchesTypes(XMLElement el, String ... types) {
        if (StringUtils.isEmpty((String)el.value_)) {
            return false;
        }
        for (String type : types) {
            if (!type.equals(el.xsiType_)) continue;
            return true;
        }
        return false;
    }
}

