/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.deployment.CredentialsEncrypter;
import com.cognos.cm.deployment.OptionsCoder;
import com.cognos.cm.deployment.PathEncoder;
import com.cognos.cm.deployment.StoreIdDecoder;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import java.util.Map;
import java.util.function.Function;

public class OptionsDecoder
extends OptionsCoder {
    private Function<String, String> pathDecoder;
    private CredentialsEncrypter encrypter;
    private Function<String, String> storeIdDecoder;

    OptionsDecoder(Function<String, String> storeIdDecoder, CredentialsEncrypter encrypter) {
        this.pathDecoder = new PathEncoder(storeIdDecoder);
        this.encrypter = encrypter;
        this.storeIdDecoder = storeIdDecoder;
    }

    public static void decode(XMLElement elValue, Map<String, String> storeIDSubstitutes) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        StoreIdDecoder storeIdDecoder = new StoreIdDecoder(store, storeIDSubstitutes);
        CredentialsEncrypter encrypter = new CredentialsEncrypter(OptionsDecoder.createEncryptingSession());
        new OptionsDecoder(storeIdDecoder, encrypter).decodeValue(elValue);
    }

    protected void decodeValue(XMLElement optionsValue) throws CMException {
        for (XMLElement option : optionsValue.getChildren()) {
            String name = option.getOptionalChildValueWithName("name");
            if (OptionsDecoder.canContainCredentials(name)) {
                XMLElement value = option.getChildWithName("value");
                try {
                    value.value_ = this.encrypter.encrypt(value.value_);
                }
                catch (CAMCryptoException ex) {
                    OptionsDecoder.throwBadValue((Exception)((Object)ex));
                }
                continue;
            }
            if (OPTIONS_WITH_OBJREFS.contains(option.xsiType_)) {
                OptionsDecoder.encodeXml(OptionsDecoder.createOptionValueIterator(option, TYPES_WITH_GUID), this.storeIdDecoder);
                continue;
            }
            OptionsDecoder.encodeXml(OptionsDecoder.createOptionValueIterator(option, TYPES_WITH_PATH), this.pathDecoder);
        }
    }
}

