/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.deployment.CredentialsDecrypter;
import com.cognos.cm.deployment.OptionsCoder;
import com.cognos.cm.deployment.PathEncoder;
import com.cognos.cm.deployment.StoreIdEncoder;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.properties.CMTypedNameValuePairArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMXMLUtils;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;

public class OptionsEncoder
extends OptionsCoder {
    private PathEncoder pathEncoder;
    private CredentialsDecrypter decrypter;
    private Function<String, String> storeIdEncoder;

    OptionsEncoder(Function<String, String> storeIdEncoder, CredentialsDecrypter decrypter) {
        this.storeIdEncoder = storeIdEncoder;
        this.pathEncoder = new PathEncoder(storeIdEncoder);
        this.decrypter = decrypter;
    }

    public static boolean encode(Object propValue) throws CMException {
        if (propValue == null) {
            return false;
        }
        CMStore store = CMExecutionContext.get().getStore();
        StoreIdEncoder storeIdEncoder = new StoreIdEncoder(store);
        CredentialsDecrypter credentials = new CredentialsDecrypter(OptionsEncoder.createEncryptingSession());
        return new OptionsEncoder(storeIdEncoder, credentials).encodeValue((CMTypedNameValuePairArray)propValue);
    }

    protected boolean encodeValue(CMTypedNameValuePairArray options) throws CMException {
        boolean bOptionsContainPassword = false;
        for (int index = 0; index < options.getSize(); ++index) {
            CMTypedNameValuePair option = options.getPair(index);
            String value = option.getValue();
            if (!StringUtils.isNotEmpty((String)value)) continue;
            if (OptionsEncoder.canContainCredentials(option.getName())) {
                this.decryptCredentials(option);
                if (option.getName().equals("archiveEncryptPassword")) continue;
                bOptionsContainPassword = true;
                continue;
            }
            if (OPTIONS_WITH_OBJREFS.contains(option.getTypeName())) {
                this.encodeValue(option, this.storeIdEncoder, TYPES_WITH_GUID);
                continue;
            }
            if (value.indexOf("storeID") == -1) continue;
            this.encodeValue(option, this.pathEncoder, TYPES_WITH_PATH);
        }
        return bOptionsContainPassword;
    }

    private void encodeValue(CMTypedNameValuePair option, Function<String, String> coder, String ... elementTypes) throws CMException {
        XMLElement root = CMXMLUtils.convertXMLString2XMLElement(option.getValue());
        if (OptionsEncoder.encodeXml(OptionsEncoder.createOptionValueIterator(root, elementTypes), coder)) {
            option.setValue(root.makeXML("", false, false));
        }
    }

    private boolean decryptCredentials(CMTypedNameValuePair option) throws CMException {
        XMLElement root = CMXMLUtils.convertXMLString2XMLElement(option.getValue());
        XMLElement value = root.getChildWithName("value");
        try {
            String decrypted = this.decrypter.decrypt(value.value_);
            if (decrypted != value.value_) {
                value.value_ = decrypted;
                option.setValue(value.makeXML("", true, false, false));
                return true;
            }
        }
        catch (CAMCryptoException e) {
            OptionsEncoder.throwBadValue((Exception)((Object)e));
        }
        return false;
    }
}

