/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cm.deployment.CredentialsDecrypter;
import com.cognos.cm.deployment.CredentialsEncrypter;
import com.cognos.cm.properties.CMNameValuePair;
import com.cognos.cm.properties.CMNameValuePairArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;

public class ParametersEncoder {
    private static final String CREDENTIAL_NAME_PREFIX = "credential:";

    private ParametersEncoder() {
    }

    public static boolean encode(Object propValue) throws CMException {
        if (propValue == null) {
            return false;
        }
        return new EncoderImpl(new CredentialsDecrypter(ParametersEncoder.createEncryptingSession())).encode((CMNameValuePairArray)propValue);
    }

    public static void decode(Object propValue) throws CMException {
        if (propValue == null) {
            return;
        }
        CredentialsEncrypter encrypter = new CredentialsEncrypter(ParametersEncoder.createEncryptingSession());
        new EncoderImpl(encrypter).encode((CMNameValuePairArray)propValue);
    }

    private static EncryptingSession createEncryptingSession() throws CMException {
        try {
            return CMServlet.CAMFactory_.createEncryptingSession();
        }
        catch (CAMCryptoException e) {
            throw new CMException((Exception)((Object)e), "cmCryptoInitFailed");
        }
    }

    private static XMLElement getUseProperty(XMLElement param) {
        XMLElement use = param.getChild("value", "item", "use");
        if (use != null && use.value_ != null) {
            return use;
        }
        return null;
    }

    static class EncoderImpl {
        private Function<String, String> encoder;

        public EncoderImpl(Function<String, String> credentialsEncoder) {
            this.encoder = credentialsEncoder;
        }

        public boolean encode(CMNameValuePairArray valueArray) throws CMException {
            boolean encoded = false;
            int size = valueArray.getSize();
            for (int i = 0; i < size; ++i) {
                CMNameValuePair item = valueArray.getPair(i);
                if (!item.getName().startsWith(ParametersEncoder.CREDENTIAL_NAME_PREFIX)) continue;
                encoded |= this.encodeCredentials(item);
            }
            return encoded;
        }

        private boolean encodeCredentials(CMNameValuePair item) throws CMException {
            String decrypted;
            String value = item.getValue();
            if (StringUtils.isEmpty((String)value)) {
                return false;
            }
            XMLElement root = CMXMLUtils.convertXMLString2XMLElement(value);
            XMLElement use = ParametersEncoder.getUseProperty(root);
            if (use != null && (decrypted = this.encoder.apply(use.value_)) != use.value_) {
                use.value_ = decrypted;
                String newPropValue = root.makeXML("", false, false, false);
                item.setValue(newPropValue.trim());
                return true;
            }
            return false;
        }
    }
}

