/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment;

import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.Lexer;
import java.util.HashMap;
import java.util.function.Function;

public class PathEncoder
implements Function<String, String> {
    private final HashMap<String, Function<String, String>> funcHandlers = new HashMap();
    private Function<String, String> function;

    public PathEncoder(Function<String, String> storeIdEncoder) {
        this.funcHandlers.put("storeID", storeIdEncoder);
    }

    public PathEncoder() {
    }

    public PathEncoder addHandler(String name, Function<String, String> handler) {
        this.funcHandlers.put(name, handler);
        return this;
    }

    @Override
    public String apply(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        try {
            boolean valueUpdated = false;
            Lexer lex = new Lexer(s);
            lex.ignoreWhitespace(false);
            StringBuilder out = new StringBuilder(256);
            String name = null;
            int state = 0;
            int token = 1;
            while (token != 0) {
                token = lex.yylex();
                String text = lex.getText();
                if (token != 25) {
                    if (token == 24) {
                        name = text;
                        state = 1;
                    } else if (token == 19) {
                        state = state == 1 && this.matchFunction(name) ? 2 : 0;
                    } else if (token == 2) {
                        String result;
                        if (state == 2 && (result = this.function.apply(text)) != text) {
                            text = result;
                            valueUpdated = true;
                        }
                        text = CMStoreXPath.attributeQuoteString(text);
                        state = 0;
                    } else {
                        state = 0;
                    }
                }
                out.append(text);
            }
            if (valueUpdated) {
                return out.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    private final boolean matchFunction(String name) {
        this.function = this.funcHandlers.get(name);
        return this.function != null;
    }
}

