/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment.exportTree;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMStringUtils;
import java.util.HashMap;

public class BatchSizeSelector {
    private int defaultSize;
    private HashMap<CMObjectClass, Integer> perClass;

    public BatchSizeSelector(int defaultValue) throws CMException {
        this.defaultSize = defaultValue;
    }

    public BatchSizeSelector(CMObjectClasses classes) throws CMException {
        this.defaultSize = AdvancedSettings.TREEEXPORT_BATCHSIZE;
        if (this.defaultSize <= 0) {
            this.defaultSize = CMDbConnection.getMaxObjectsInline();
        }
        this.initPerClassMap(AdvancedSettings.TREEEXPORT_BATCHSIZE_PERCLASS, classes);
    }

    protected void initPerClassMap(String value, CMObjectClasses classes) throws CMException {
        if (this.defaultSize <= 0 || value == null || value.length() == 0) {
            return;
        }
        this.perClass = new HashMap();
        try {
            for (String part : CMStringUtils.split(value, ';')) {
                int n = part.indexOf(58);
                if (n == -1) {
                    throw new IllegalArgumentException();
                }
                Integer size = Integer.valueOf(part.substring(n + 1));
                for (String cls : CMStringUtils.split(part.substring(0, n), ',')) {
                    CMObjectClass objCls = classes.getClassByName(cls, true);
                    if (objCls == null) {
                        throw new IllegalArgumentException();
                    }
                    this.perClass.put(objCls, size);
                }
            }
        }
        catch (Exception e) {
            throw this.getError(value);
        }
    }

    protected CMException getError(String value) {
        return new CMException("cmInvalidValueForAdvancedSetting", new CMException.Parm("name", "TREEEXPORT_BATCHSIZE_PERCLASS"), new CMException.Parm("value", value));
    }

    public int getBatchSize(CMObjectClass cls) {
        if (cls == null || this.perClass == null) {
            return this.defaultSize;
        }
        Integer size = this.perClass.get(cls);
        return size == null ? this.defaultSize : size;
    }

    public boolean isClassBatchSizeSet(CMObjectClass cls) {
        return this.perClass.containsKey(cls);
    }
}

