/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment.exportTree;

import com.cognos.cm.deployment.exportTree.ExportTree;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.store.InternalStoreId;

public class ExportEntry {
    private int id;
    private InternalStoreId storeid;
    private CMObjectClass oclass;
    private int tenantID;
    private ExportTree tree;
    private ExportEntry parent;
    private ExportEntry child;
    private ExportEntry sibling;

    public ExportEntry(int id, InternalStoreId storeid, CMObjectClass cls, ExportTree tree, int tenantID) {
        this.storeid = storeid;
        this.oclass = cls;
        this.tree = tree;
        this.id = id;
        this.tenantID = tenantID;
    }

    public int getTenantID() {
        return this.tenantID;
    }

    public CMObjectClass getObjectClass() {
        return this.oclass;
    }

    public InternalStoreId getStoreId() {
        return this.storeid;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public int getParentID() {
        return this.parent == null ? 0 : this.parent.id;
    }

    public ExportEntry getParent() {
        return this.parent;
    }

    public ExportEntry getChild() {
        return this.child;
    }

    public ExportEntry getSibling() {
        return this.sibling;
    }

    void addChild(ExportEntry entry) {
        if (entry == this) {
            return;
        }
        entry.parent = this;
        entry.sibling = this.child;
        this.child = entry;
    }

    public void trim() {
        if (this.id < 0) {
            this.delete();
        } else {
            this.tree.decRef(this.oclass, 1);
        }
    }

    public void delete() {
        if (this.tree == null) {
            throw new IllegalStateException("Entry is not linked to the tree");
        }
        while (this.child != null) {
            this.child.delete();
        }
        this.unlink();
        if (this.tree.getRoot() == this) {
            this.tree.reset();
        }
        this.tree = null;
    }

    private void unlink() {
        if (this.parent == null) {
            return;
        }
        if (this.id < 0) {
            this.tree.decRef(this.oclass, 1);
        }
        if (this.parent.child == this) {
            this.parent.child = this.sibling;
        } else {
            ExportEntry prev = this.parent.child;
            while (prev.sibling != this) {
                prev = prev.sibling;
            }
            prev.sibling = this.sibling;
        }
        this.parent = null;
        this.sibling = null;
    }
}

