/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment.exportTree;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import java.util.HashMap;

public class ExportPriorityMap {
    private HashMap<CMObjectClass, Integer> map;
    private int minPriority = Integer.MAX_VALUE;
    private int maxPriority = 0;

    private ExportPriorityMap(CMObjectClasses classes) {
        this.map = new HashMap(300);
        this.sanityCheck(classes);
        int priority = classes.getAllClasses().length;
        CMObjectClass root = classes.getClassByName("root");
        this.setPriority(root, priority, classes);
    }

    public static ExportPriorityMap create(CMObjectClasses classes) {
        return new ExportPriorityMap(classes);
    }

    private void sanityCheck(CMObjectClasses classes) {
        CMObjectClass agentcls;
        CMObjectClass foldercls = classes.getClassByName("folder");
        if (!foldercls.isValidChildClass(agentcls = classes.getClassByName("agentDefinition"))) {
            throw new IllegalStateException("cm metadata error");
        }
    }

    private void setPriority(CMObjectClass cls, int priority, CMObjectClasses classes) {
        if (priority < 0) {
            throw new IllegalStateException("Object class tree contains cycles");
        }
        Integer ip = this.map.get(cls);
        if (ip != null && ip <= priority) {
            return;
        }
        if (this.maxPriority < priority) {
            this.maxPriority = priority;
        }
        if (this.minPriority > priority) {
            this.minPriority = priority;
        }
        this.map.put(cls, priority);
        for (CMObjectClass child : cls.getValidChildObjectCleasses()) {
            if (child == cls) continue;
            if (child.isValidChildClass(cls)) {
                this.setPriority(child, priority, classes);
                continue;
            }
            this.setPriority(child, priority - 1, classes);
        }
    }

    public int getPriority(CMObjectClass cls) {
        if (this.map.get(cls) == null) {
            throw new IllegalStateException("unknown class: " + cls.getName());
        }
        return this.map.get(cls);
    }

    public int getMinPriority() {
        return this.minPriority;
    }

    public int getMaxPriority() {
        return this.maxPriority;
    }
}

