/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment.exportTree;

import com.cognos.cm.deployment.exportTree.ExportPriorityMap;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class ExportPriorityQueue {
    private static ExportPriorityMap cachedPriorityMap;
    private static CMObjectClasses cachedClassSet;
    private ExportPriorityMap priorityMap;
    private int[] refCounts;
    private HashSet<CMObjectClass>[] queue;
    private int queueSize;

    public ExportPriorityQueue(CMObjectClasses clsSet) {
        this.buildPriorityMap(clsSet);
        this.refCounts = this.allocateRefCountArray(clsSet);
        int size = this.priorityMap.getMaxPriority() - this.priorityMap.getMinPriority() + 1;
        this.queue = new HashSet[size];
        this.queueSize = 0;
    }

    private int[] allocateRefCountArray(CMObjectClasses clsSet) {
        CMObjectClass[] classes = clsSet.getAllClasses();
        int id = classes[classes.length - 1].getID();
        int size = this.getIndexSize(id);
        return new int[size];
    }

    private synchronized void buildPriorityMap(CMObjectClasses classSet) {
        if (cachedClassSet == classSet) {
            this.priorityMap = cachedPriorityMap;
        } else {
            this.priorityMap = ExportPriorityMap.create(classSet);
            if (cachedPriorityMap == null) {
                cachedPriorityMap = this.priorityMap;
                cachedClassSet = classSet;
            }
        }
    }

    public void reset() {
        Arrays.fill(this.refCounts, 0);
        Arrays.fill(this.queue, null);
        this.queueSize = 0;
    }

    public void incRef(CMObjectClass cls, int count) {
        int index = this.getClassIndex(cls);
        if (this.refCounts[index] == 0) {
            int level = this.priorityMap.getPriority(cls) - this.priorityMap.getMinPriority();
            if (this.queue[level] == null) {
                this.queue[level] = new HashSet();
            }
            this.queue[level].add(cls);
            if (this.queueSize < level) {
                this.queueSize = level;
            }
        }
        int n = index;
        this.refCounts[n] = this.refCounts[n] + count;
    }

    public void decRef(CMObjectClass cls, int count) {
        int index = this.getClassIndex(cls);
        if (this.refCounts[index] < count) {
            throw new IllegalStateException("refCount < 0");
        }
        int n = index;
        this.refCounts[n] = this.refCounts[n] - count;
        if (this.refCounts[index] == 0) {
            int level = this.priorityMap.getPriority(cls) - this.priorityMap.getMinPriority();
            this.queue[level].remove(cls);
            if (this.queue[level].isEmpty()) {
                this.queue[level] = null;
            }
        }
    }

    protected int getIndexSize(int id) {
        return id;
    }

    protected int getClassIndex(CMObjectClass cls) {
        return cls.getID() - 1;
    }

    public boolean isEmpty() {
        return this.getCandidateClasses() == null;
    }

    public Collection<CMObjectClass> getCandidateClasses() {
        while (this.queueSize >= 0) {
            if (this.queue[this.queueSize] != null) {
                return this.queue[this.queueSize];
            }
            --this.queueSize;
        }
        return null;
    }

    void discard(Collection<CMObjectClass> candidates) {
        for (CMObjectClass cls : new ArrayList<CMObjectClass>(candidates)) {
            int idx = this.getClassIndex(cls);
            if (this.refCounts[idx] <= 0) continue;
            this.decRef(cls, this.refCounts[idx]);
        }
    }
}

