/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment.exportTree;

import com.cognos.cm.deployment.exportTree.ExportEntry;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cmutils.collections.Filter;
import com.cognos.cmutils.collections.FilterIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ExportSet
implements Iterable<HashMap<InternalStoreId, ExportEntry>>,
Iterator<HashMap<InternalStoreId, ExportEntry>> {
    private static final int DEFAULT_BATCH_SIZE = 200;
    private HashMap<InternalStoreId, ExportEntry> set = new HashMap();
    private Iterator<ExportEntry> treeIterator;
    private CMObjectClass cls;
    private int batchSize = 200;
    private ExportEntry next;

    ExportSet(Iterator<ExportEntry> iterator, Collection<CMObjectClass> classes) {
        this.next = this.findFirstEntry(iterator, classes);
        if (this.next != null) {
            this.cls = this.next.getObjectClass();
            Filter<ExportEntry> filter = new Filter<ExportEntry>(){

                public boolean accept(ExportEntry entry) {
                    return entry.getObjectClass() == ExportSet.this.cls && entry.getID() < 0;
                }
            };
            this.treeIterator = new FilterIterator(iterator, (Filter)filter);
        } else {
            List emptyList = Collections.emptyList();
            this.treeIterator = emptyList.iterator();
        }
    }

    private ExportEntry findFirstEntry(Iterator<ExportEntry> it, Collection<CMObjectClass> classes) {
        while (it.hasNext()) {
            ExportEntry entry = it.next();
            if (entry.getID() >= 0 || !classes.contains(entry.getObjectClass())) continue;
            return entry;
        }
        return null;
    }

    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void discard() {
        if (this.next != null) {
            this.next.trim();
            this.next = null;
            this.resetForNextBatch();
            while (this.treeIterator.hasNext()) {
                this.treeIterator.next().trim();
            }
        }
    }

    public CMObjectClass getObjectClass() {
        return this.cls;
    }

    @Override
    public Iterator<HashMap<InternalStoreId, ExportEntry>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (!this.set.isEmpty()) {
            this.resetForNextBatch();
        }
        return this.next != null;
    }

    @Override
    public HashMap<InternalStoreId, ExportEntry> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        for (int size = 0; size < this.batchSize; ++size) {
            this.set.put(this.next.getStoreId(), this.next);
            if (!this.treeIterator.hasNext()) {
                this.next = null;
                break;
            }
            this.next = this.treeIterator.next();
        }
        return this.set;
    }

    private void resetForNextBatch() {
        for (ExportEntry entry : this.set.values()) {
            entry.trim();
        }
        this.set.clear();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

