/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment.exportTree;

import com.cognos.cm.deployment.exportTree.ExportEntry;
import com.cognos.cm.deployment.exportTree.ExportPriorityQueue;
import com.cognos.cm.deployment.exportTree.ExportSet;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cmutils.collections.Filter;
import com.cognos.cmutils.collections.TraverseOrder;
import com.cognos.cmutils.collections.TreeNavigator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ExportTree
implements TreeNavigator<ExportEntry> {
    protected ExportEntry root;
    protected ExportPriorityQueue classQueue;
    protected HashMap<Integer, ExportEntry> entries = new HashMap(64);
    private static final Filter<ExportEntry> preFilter = new Filter<ExportEntry>(){

        public boolean accept(ExportEntry e) {
            return e.getParentID() >= 0;
        }
    };

    public ExportTree(CMObjectClasses classes) {
        this.classQueue = new ExportPriorityQueue(classes);
    }

    public ExportEntry add(int cmid, int pcmid, InternalStoreId storeID, CMObjectClass cls, int tenantID) {
        ExportEntry entry = new ExportEntry(cmid, storeID, cls, this, tenantID);
        this.add(entry, pcmid);
        return entry;
    }

    protected void add(ExportEntry entry, int pcmid) {
        if (this.entries == null) {
            throw new IllegalStateException("The tree is already built");
        }
        int cmid = entry.getID();
        ExportEntry old = this.entries.put(cmid, entry);
        if (old != null) {
            this.entries.put(cmid, old);
            throw new IllegalStateException("duplicate entry: " + cmid);
        }
        this.classQueue.incRef(entry.getObjectClass(), 1);
        entry.setID(pcmid);
    }

    public void build(int rootId) {
        this.root = this.initRoot(rootId);
        if (this.root != null) {
            this.linkEntries();
        }
        this.entries = null;
    }

    private ExportEntry initRoot(int rootId) {
        ExportEntry entry = this.entries.get(rootId);
        if (entry != null) {
            ExportEntry parent = this.entries.get(entry.getID());
            if (parent == null || parent == entry) {
                entry.setID(-1);
            } else {
                entry = null;
            }
        }
        return entry;
    }

    private void linkEntries() {
        ArrayList<ExportEntry> invalidEntries = new ArrayList<ExportEntry>();
        for (ExportEntry entry : this.entries.values()) {
            ExportEntry parent = this.entries.get(entry.getID());
            if (ExportTree.isValidParentChild(parent, entry)) {
                parent.addChild(entry);
            } else if (entry != this.root) {
                invalidEntries.add(entry);
            }
            entry.setID(-1);
        }
        for (ExportEntry entry : invalidEntries) {
            entry.delete();
        }
    }

    private static boolean isValidParentChild(ExportEntry parent, ExportEntry child) {
        return parent == null ? false : parent.getObjectClass().isValidChildClass(child.getObjectClass());
    }

    public void reset() {
        this.root = null;
        this.entries = new HashMap();
        this.classQueue.reset();
    }

    public ExportEntry getRoot() {
        return this.root;
    }

    public void remove(ExportEntry entry) {
        entry.delete();
    }

    public Iterable<ExportEntry> entries(TraverseOrder order, Filter<ExportEntry> filter) {
        return order.createIterator((TreeNavigator)this, filter);
    }

    public void decRef(CMObjectClass cls, int count) {
        this.classQueue.decRef(cls, count);
    }

    public ExportEntry getChild(ExportEntry node) {
        return node.getChild();
    }

    public ExportEntry getParent(ExportEntry node) {
        return node.getParent();
    }

    public ExportEntry getSibling(ExportEntry node) {
        return node.getSibling();
    }

    public Iterable<ExportSet> exportSets() {
        return new SetsIterator();
    }

    private class SetsIterator
    implements Iterable<ExportSet>,
    Iterator<ExportSet> {
        private ExportSet next;

        private SetsIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.findNextSet();
            }
            return this.next != null;
        }

        @Override
        public ExportSet next() {
            if (this.hasNext()) {
                ExportSet result = this.next;
                this.next = null;
                return result;
            }
            throw new NoSuchElementException();
        }

        private ExportSet findNextSet() {
            while (!ExportTree.this.classQueue.isEmpty()) {
                Collection<CMObjectClass> candidates = ExportTree.this.classQueue.getCandidateClasses();
                Iterable it = TraverseOrder.levelorder.createIterator((TreeNavigator)ExportTree.this, preFilter);
                ExportSet result = new ExportSet(it.iterator(), candidates);
                if (result.getObjectClass() != null) {
                    return result;
                }
                ExportTree.this.classQueue.discard(candidates);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<ExportSet> iterator() {
            return this;
        }
    }
}

