/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.deployment.exportTree;

import com.cognos.cm.deployment.DeploymentExportArchive;
import com.cognos.cm.deployment.HomeFolderIndexWriter;
import com.cognos.cm.deployment.exportTree.ExportEntry;
import com.cognos.cm.deployment.exportTree.ExportTree;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMStringArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.BaseCmObject;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cmutils.path.SearchPathEncoder;
import java.util.HashSet;
import java.util.List;

public class HomeFolderExportTree
extends ExportTree {
    private CMStore store;
    private HashSet<String> references;

    public HomeFolderExportTree(CMStore store) {
        super(store.getObjectClasses());
        this.store = store;
        this.references = new HashSet();
    }

    public void add(CMStringArray references) {
        if (references == null) {
            return;
        }
        for (int i = 0; i < references.getSize(); ++i) {
            String item = references.getString(i);
            if (item == null || item.isEmpty()) continue;
            this.references.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() throws CMException {
        if (this.references.isEmpty()) {
            return;
        }
        CMObjectClasses classes = this.store.getObjectClasses();
        this.createRoot();
        CMStoreQueryResults results = null;
        block5: for (String docid : this.references) {
            try {
                int cmid;
                List<BaseCmObject> ancestors;
                CMStorePath path = this.getDocumentPath(docid);
                this.requestLocks(path);
                results = this.store.executeQuery(path, null, null, 10, 1, null);
                if (!results.next() || !this.isValidReference(ancestors = this.getAncestors(cmid = results.getObjectID()), this.root.getStoreId())) continue;
                this.createEntryFromResultSet(results, docid);
                int last = ancestors.size() - 2;
                if (last <= 0) continue;
                for (int i = 0; i < last; ++i) {
                    BaseCmObject ancestor = ancestors.get(i);
                    if (this.entries.containsKey(ancestor.cmid)) continue block5;
                    int pcmid = ancestors.get((int)(i + 1)).cmid;
                    this.add(ancestor.cmid, pcmid, ancestor.storeID, classes.getClassByID(ancestor.classID), ancestor.tenantID);
                }
            }
            finally {
                if (results != null) {
                    results.release();
                }
                this.releaseLocks();
            }
        }
        this.references = null;
        this.build(this.root.getID());
        this.decRef(this.root.getObjectClass(), 1);
        this.root.setID(0);
    }

    public void writeIndex(DeploymentExportArchive archive) throws CMException {
        HomeFolderIndexWriter riw = new HomeFolderIndexWriter(this);
        riw.writeTo(archive);
    }

    private void requestLocks(CMStorePath path) throws CMException {
        this.store.getLockManager().requestLocks(path);
    }

    private void releaseLocks() throws CMException {
        this.store.getLockManager().releaseLocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRoot() throws CMException {
        CMStoreQueryResults results = null;
        CMStoreXPath path = new CMStoreXPath("/folder[@name=\"home\"]");
        this.requestLocks(path);
        try {
            results = this.store.executeQuery(path, null, null, 10, 512, null);
            if (!results.next()) {
                throw new CMStoreObjectNotFound("/folder[@name=\"home\"]");
            }
            int cmid = results.getObjectID();
            this.root = this.createEntryFromResultSet(results, null);
            this.root.setID(cmid);
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.releaseLocks();
        }
    }

    private ExportEntry createEntryFromResultSet(CMStoreQueryResults rs, String documentId) {
        CMObjectClass cls = rs.getObjectClass();
        int tenantID = rs.getTenantID();
        int cmid = rs.getObjectID();
        int pcmid = rs.getParentObjectID();
        InternalStoreId storeid = this.store.getInternalStoreId(cmid);
        ExportEntry entry = null;
        entry = documentId == null ? new ExportEntry(cmid, storeid, cls, this, tenantID) : new DocumentExportEntry(cmid, storeid, cls, this, tenantID, documentId);
        this.add(entry, pcmid);
        return entry;
    }

    private List<BaseCmObject> getAncestors(int cmid) throws CMException {
        return this.store.getCache().getAncestorInfo(cmid);
    }

    private boolean isValidReference(List<BaseCmObject> ancestors, InternalStoreId homeFolder) {
        return ancestors.size() > 2 && ancestors.get((int)(ancestors.size() - 2)).storeID == homeFolder;
    }

    private CMStorePath getDocumentPath(String documentID) throws CMException {
        String path = "//*[@documentID=" + SearchPathEncoder.quoteString((String)documentID) + "]";
        return new CMStoreXPath(path);
    }

    public static class DocumentExportEntry
    extends ExportEntry {
        private String documentId;

        public DocumentExportEntry(int id, InternalStoreId storeid, CMObjectClass cls, ExportTree tree, int tenantID, String documentId) {
            super(id, storeid, cls, tree, tenantID);
            this.documentId = documentId;
        }

        public String getDocumentId() {
            return this.documentId;
        }
    }
}

