/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.Counter;

public abstract class AbstractCounter
implements Counter {
    public Counter makeGlobal() {
        return new SynchronizedCounter(this);
    }

    public Counter makeThreadLocal() {
        return new ThreadLocalCounter(this);
    }

    @Override
    public Class<? extends Counter> getType() {
        return this.getClass();
    }

    protected static class ThreadLocalCounter
    implements Counter {
        private Counter target_;
        private ThreadLocal<Counter> threadLocal;
        private int refCount;

        public ThreadLocalCounter(Counter target) {
            this.target_ = target;
            this.threadLocal = new ThreadLocal<Counter>(){

                @Override
                public Counter initialValue() {
                    if (refCount == 0) {
                        return new Dummy();
                    }
                    return target_.newInstance();
                }
            };
        }

        public synchronized void enable(boolean enable) {
            if (enable) {
                ++this.refCount;
            } else {
                if (this.refCount == 0) {
                    return;
                }
                --this.refCount;
            }
        }

        @Override
        public Counter getState() {
            Counter result = this.threadLocal.get();
            if (result instanceof Dummy) {
                result = this.target_;
            }
            return result;
        }

        @Override
        public void increment(long delta, Object data) {
            this.threadLocal.get().increment(delta, data);
        }

        @Override
        public void increment(long delta) {
            this.threadLocal.get().increment(delta);
        }

        @Override
        public Counter newInstance() {
            return this.target_.newInstance();
        }

        @Override
        public void reset() {
            Counter c = this.threadLocal.get();
            c.reset();
            if (this.refCount == 0) {
                if (!(c instanceof Dummy)) {
                    this.threadLocal.remove();
                }
            } else if (c instanceof Dummy) {
                this.threadLocal.remove();
            }
        }

        @Override
        public void update(Counter state) {
            this.threadLocal.get().update(state);
        }

        @Override
        public Class<? extends Counter> getType() {
            return this.target_.getClass();
        }

        private static class Dummy
        implements Counter {
            private Dummy() {
            }

            @Override
            public Counter getState() {
                return this;
            }

            @Override
            public Class<? extends Counter> getType() {
                return this.getClass();
            }

            @Override
            public void increment(long delta, Object data) {
            }

            @Override
            public void increment(long delta) {
            }

            @Override
            public Counter newInstance() {
                return null;
            }

            @Override
            public void reset() {
            }

            @Override
            public void update(Counter state) {
            }
        }
    }

    protected static class SynchronizedCounter
    implements Counter {
        protected Counter[] slaves;

        protected SynchronizedCounter(Counter target) {
            this.slaves = new Counter[]{new Slave(target)};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Counter createSlave() {
            Slave result = new Slave(this.newInstance());
            SynchronizedCounter synchronizedCounter = this;
            synchronized (synchronizedCounter) {
                Counter[] tmp = new Counter[this.slaves.length + 1];
                System.arraycopy(this.slaves, 0, tmp, 0, this.slaves.length);
                tmp[this.slaves.length] = result;
                this.slaves = tmp;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSlave(Counter c) {
            SynchronizedCounter synchronizedCounter = this;
            synchronized (synchronizedCounter) {
                int pos;
                if (this.slaves.length == 1) {
                    throw new IllegalArgumentException();
                }
                for (pos = 1; pos < this.slaves.length && this.slaves[pos] != c; ++pos) {
                }
                if (pos == this.slaves.length) {
                    throw new IllegalArgumentException();
                }
                Counter[] tmp = new Counter[this.slaves.length - 1];
                System.arraycopy(this.slaves, 0, tmp, 0, pos);
                if (pos < tmp.length) {
                    System.arraycopy(this.slaves, pos + 1, tmp, pos, tmp.length - pos);
                }
                this.slaves = tmp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Counter getState() {
            Counter master;
            SynchronizedCounter synchronizedCounter = this;
            synchronized (synchronizedCounter) {
                master = this.slaves[0];
            }
            return master.getState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<? extends Counter> getType() {
            Counter master;
            SynchronizedCounter synchronizedCounter = this;
            synchronized (synchronizedCounter) {
                master = this.slaves[0];
            }
            return master.getType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void increment(long delta, Object data) {
            SynchronizedCounter synchronizedCounter = this;
            synchronized (synchronizedCounter) {
                for (Counter c : this.slaves) {
                    c.increment(delta, data);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void increment(long delta) {
            SynchronizedCounter synchronizedCounter = this;
            synchronized (synchronizedCounter) {
                for (Counter c : this.slaves) {
                    c.increment(delta);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Counter newInstance() {
            SynchronizedCounter synchronizedCounter = this;
            synchronized (synchronizedCounter) {
                return this.slaves[0].newInstance();
            }
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void update(Counter state) {
            throw new UnsupportedOperationException();
        }

        protected static class Slave
        implements Counter {
            private Counter target;

            public Slave(Counter target) {
                this.target = target;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Counter getState() {
                Counter counter = this.target;
                synchronized (counter) {
                    return this.target.getState();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void increment(long delta, Object data) {
                Counter counter = this.target;
                synchronized (counter) {
                    this.target.increment(delta, data);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void increment(long delta) {
                Counter counter = this.target;
                synchronized (counter) {
                    this.target.increment(delta);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reset() {
                Counter counter = this.target;
                synchronized (counter) {
                    this.target.reset();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update(Counter state) {
                Counter counter = this.target;
                synchronized (counter) {
                    this.target.update(state);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Counter newInstance() {
                Counter counter = this.target;
                synchronized (counter) {
                    return this.target.newInstance();
                }
            }

            @Override
            public Class<? extends Counter> getType() {
                return this.target.getClass();
            }
        }
    }
}

