/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.AbstractCounter;
import com.cognos.cm.diagnostics.Counter;

public class AccumulatingCounter
extends AbstractCounter {
    protected long value;
    protected int callCount;

    @Override
    public Counter getState() {
        AccumulatingCounter result = new AccumulatingCounter();
        result.value = this.value;
        result.callCount = this.callCount;
        return result;
    }

    @Override
    public void increment(long delta, Object data) {
        this.value += delta;
        ++this.callCount;
    }

    @Override
    public void increment(long delta) {
        this.value += delta;
        ++this.callCount;
    }

    @Override
    public Counter newInstance() {
        return new AccumulatingCounter();
    }

    @Override
    public void reset() {
        this.value = 0L;
        this.callCount = 0;
    }

    @Override
    public void update(Counter state) {
        if (!(state instanceof AccumulatingCounter)) {
            throw new IllegalArgumentException();
        }
        this.value += ((AccumulatingCounter)state).value;
        this.callCount += ((AccumulatingCounter)state).callCount;
    }

    public long getValue() {
        return this.value;
    }

    public int getCallCount() {
        return this.callCount;
    }
}

