/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.AbstractCounter;
import com.cognos.cm.diagnostics.ContextFilter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.CounterDescriptor;
import com.cognos.cm.diagnostics.DiagnosticsContext;
import com.cognos.cm.diagnostics.History;
import com.cognos.cm.diagnostics.ReportGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class Aggregator {
    private static final Timer updateTimer = new Timer("AggregatorUpdateTimer", true);
    protected State state;
    protected String name;
    protected CounterDescriptor[] descriptors;
    protected Counter[] counters;
    protected ContextFilter filter = null;
    protected DiagnosticsContext.Param[] groups = null;
    protected long trackingPeriod;
    protected long intervalDuration;
    protected int numberOfIntervals;
    protected boolean isGlobal;
    protected ReportGenerator reporter = null;
    protected Object mutex = new Object();
    protected TimerTask task = null;
    protected HashMap<String, History> histories = new HashMap();

    private void checkCounterTypeConsistency() {
        if (this.counters.length > 1) {
            Class<? extends Counter> type = this.counters[0].getType();
            Class<?> cls = this.counters[0].getClass();
            for (int i = 1; i < this.counters.length; ++i) {
                if (this.counters[i].getType() == type && this.counters[i].getClass() == cls) continue;
                throw new IllegalArgumentException("Inconsistent counter types");
            }
        }
    }

    public Aggregator(String name, CounterDescriptor ... descriptors) {
        this.name = name;
        this.descriptors = new CounterDescriptor[descriptors.length];
        this.counters = new Counter[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            this.descriptors[i] = descriptors[i];
            this.counters[i] = descriptors[i].getCounter();
        }
        this.checkCounterTypeConsistency();
        this.intervalDuration = 600000L;
        this.numberOfIntervals = 6;
        this.isGlobal = this.counters[0] instanceof AbstractCounter.SynchronizedCounter;
        if (this.isGlobal) {
            this.createSlaves();
        } else {
            this.enableCounters(true);
        }
        this.state = State.INITIALIZING;
    }

    public String getName() {
        return this.name;
    }

    public void setFilter(ContextFilter filter) {
        this.checkState(State.INITIALIZING);
        if (this.isGlobal) {
            throw new IllegalStateException("can not use filter with global counters");
        }
        if (filter.isEmpty()) {
            filter = null;
        }
        this.filter = filter;
    }

    public ContextFilter getFilter() {
        return this.filter;
    }

    public void setGroups(DiagnosticsContext.Param ... groups) {
        this.checkState(State.INITIALIZING);
        if (this.isGlobal) {
            throw new IllegalStateException("can not apply grouping to global counters");
        }
        if (groups.length == 0) {
            this.groups = null;
            return;
        }
        this.groups = new DiagnosticsContext.Param[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            this.groups[i] = groups[i];
            for (int j = 0; j < i; ++j) {
                if (this.groups[i] != groups[j]) continue;
                throw new IllegalArgumentException("Duplicate group: " + (Object)((Object)groups[i]));
            }
        }
    }

    public DiagnosticsContext.Param[] getGroups() {
        return this.groups;
    }

    public boolean hasGroups() {
        return this.getGroups() != null;
    }

    public CounterDescriptor[] getCounters() {
        return this.descriptors;
    }

    public Class<? extends Counter> getCounterType() {
        return this.counters[0].getType();
    }

    public void setHistory(long duration, int intervals) {
        this.checkState(State.INITIALIZING);
        if (intervals < 1 || intervals > 100) {
            throw new IllegalArgumentException("invalid number of intervals");
        }
        if (duration < 1000L) {
            throw new IllegalArgumentException("invalid interval duration");
        }
        this.intervalDuration = duration;
        this.numberOfIntervals = intervals;
    }

    public int getNumberOfInntervals() {
        return this.numberOfIntervals;
    }

    public long getInntervalDuration() {
        return this.intervalDuration;
    }

    public void setReportGenerator(ReportGenerator rg) {
        this.checkState(State.INITIALIZING);
        this.reporter = rg;
    }

    public ReportGenerator getReportGenerator() {
        return this.reporter;
    }

    public void start() {
        this.checkState(State.INITIALIZING);
        this.state = State.RUNNING;
        if (this.isGlobal) {
            this.scheduleUpdates();
        }
    }

    public void shutdown() {
        this.checkState(State.RUNNING);
        this.state = State.STOPPED;
        if (this.isGlobal) {
            this.cancelTimerTask();
            this.deleteSlaves();
        } else {
            this.enableCounters(false);
        }
        if (this.reporter != null) {
            for (Map.Entry<String, History> entry : this.histories.entrySet()) {
                this.reporter.print(this.descriptors, entry.getKey(), entry.getValue().getCurrentInterval());
            }
            this.reporter.printFooter();
            this.reporter.close();
        }
    }

    public void update(long timestamp) {
        this.checkState(State.RUNNING);
        if (this.isGlobal) {
            return;
        }
        this.updateHistory(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(ReportGenerator generator) {
        this.checkState(State.RUNNING);
        HashMap<String, List<History.Interval>> map = new HashMap<String, List<History.Interval>>();
        Iterator iterator = this.mutex;
        synchronized (iterator) {
            for (Map.Entry<String, History> entry : this.histories.entrySet()) {
                History history = entry.getValue();
                map.put(entry.getKey(), history.getIntervals());
            }
        }
        generator.printHeader();
        for (Map.Entry entry : map.entrySet()) {
            String group = (String)entry.getKey();
            if (group.length() == 0 && this.groups == null) {
                group = null;
            }
            for (History.Interval interval : (List)entry.getValue()) {
                generator.print(this.descriptors, group, interval);
            }
        }
        generator.printFooter();
    }

    protected String getCurrentGroup(DiagnosticsContext context) {
        if (this.groups == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.groups.length; ++i) {
            String param;
            if (i != 0) {
                buf.append('|');
            }
            if ((param = context.get(this.groups[i])) == null) continue;
            buf.append(param);
        }
        return buf.toString();
    }

    protected History getGroupHistory(String group, long timestamp) {
        History history = this.histories.get(group);
        if (history == null) {
            timestamp -= timestamp % this.intervalDuration;
            history = new History(this.counters, this.intervalDuration, this.numberOfIntervals, timestamp);
            this.histories.put(group, history);
        }
        return history;
    }

    private void scheduleUpdates() {
        if (this.task != null) {
            this.task.cancel();
        } else {
            this.task = new TimerTask(){

                @Override
                public void run() {
                    long timestamp = System.currentTimeMillis();
                    Aggregator.this.updateHistory(timestamp);
                }
            };
        }
        long delay = System.currentTimeMillis() % this.intervalDuration - 500L;
        if (delay < 0L) {
            delay += this.intervalDuration;
        }
        updateTimer.scheduleAtFixedRate(this.task, delay, this.intervalDuration);
    }

    private void cancelTimerTask() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHistory(long timestamp) {
        DiagnosticsContext diagCtx = DiagnosticsContext.get();
        if (this.filter == null || this.filter.match(diagCtx)) {
            String group = this.getCurrentGroup(diagCtx);
            History.Interval interval = null;
            Object object = this.mutex;
            synchronized (object) {
                History history = this.getGroupHistory(group, timestamp);
                interval = history.update(timestamp, this.reporter != null);
                if (this.isGlobal) {
                    this.resetSlaves();
                }
            }
            if (interval != null) {
                this.reporter.print(this.descriptors, group, interval);
            }
        }
    }

    private void resetSlaves() {
        for (Counter c : this.counters) {
            c.reset();
        }
    }

    private void createSlaves() {
        for (int i = 0; i < this.descriptors.length; ++i) {
            AbstractCounter.SynchronizedCounter master = (AbstractCounter.SynchronizedCounter)this.descriptors[i].getCounter();
            this.counters[i] = master.createSlave();
        }
    }

    private void deleteSlaves() {
        for (int i = 0; i < this.descriptors.length; ++i) {
            AbstractCounter.SynchronizedCounter master = (AbstractCounter.SynchronizedCounter)this.descriptors[i].getCounter();
            master.removeSlave(this.counters[i]);
        }
    }

    private void checkState(State expected) {
        if (this.state != expected) {
            throw new IllegalStateException("Operation can not be performed at this state (" + this.state.name() + ")");
        }
    }

    private void enableCounters(boolean enable) {
        for (Counter c : this.counters) {
            ((AbstractCounter.ThreadLocalCounter)c).enable(enable);
        }
    }

    private static enum State {
        INITIALIZING,
        RUNNING,
        STOPPED;

    }
}

