/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.AbstractCounter;
import com.cognos.cm.diagnostics.Counter;
import java.util.HashMap;
import java.util.Map;

public class AllInOneCounter
extends AbstractCounter {
    private HashMap<String, Data> map;

    public AllInOneCounter() {
        this.map = new HashMap();
    }

    protected AllInOneCounter(AllInOneCounter src) {
        this.map = new HashMap(src.map.size());
        for (Map.Entry<String, Data> entry : src.map.entrySet()) {
            this.map.put(entry.getKey(), new Data(entry.getValue()));
        }
    }

    @Override
    public Counter getState() {
        return new AllInOneCounter(this);
    }

    @Override
    public void increment(long delta, Object value) {
        String key = value.toString();
        Data data = this.map.get(key);
        if (data == null) {
            data = new Data();
            this.map.put(key, data);
        }
        data.increment(delta);
    }

    @Override
    public void increment(long delta) {
        Data data = this.map.get("");
        if (data == null) {
            data = new Data();
            this.map.put("", data);
        }
        data.increment(delta);
    }

    @Override
    public Counter newInstance() {
        return new AllInOneCounter();
    }

    @Override
    public void reset() {
        this.map.clear();
    }

    @Override
    public void update(Counter state) {
        if (!(state instanceof AllInOneCounter)) {
            throw new IllegalArgumentException("state is not instance of AllInOneCounter");
        }
        for (Map.Entry<String, Data> entry : ((AllInOneCounter)state).map.entrySet()) {
            String key = entry.getKey();
            Data source = entry.getValue();
            Data target = this.map.get(key);
            if (target == null) {
                target = new Data();
                this.map.put(key, target);
            }
            target.update(source);
        }
    }

    public int size() {
        return this.map.size();
    }

    public Iterator entries() {
        return new Iterator(this.map.entrySet().iterator());
    }

    public static class Iterator {
        private java.util.Iterator<Map.Entry<String, Data>> it;
        private Map.Entry<String, Data> entry;

        private Iterator(java.util.Iterator<Map.Entry<String, Data>> i) {
            this.it = i;
            this.entry = null;
        }

        public boolean next() {
            if (!this.it.hasNext()) {
                return false;
            }
            this.entry = this.it.next();
            return true;
        }

        public long getValue() {
            this.checkState();
            return this.entry.getValue().value;
        }

        public String getData() {
            this.checkState();
            return this.entry.getKey();
        }

        public long getCallCount() {
            this.checkState();
            return this.entry.getValue().count;
        }

        public long getMinValue() {
            this.checkState();
            return this.entry.getValue().minValue;
        }

        public long getMaxValue() {
            this.checkState();
            return this.entry.getValue().maxValue;
        }

        public long getStdDev() {
            this.checkState();
            Data data = this.entry.getValue();
            double count = data.count;
            double avg = (double)data.value / count;
            double stddev = Math.sqrt((double)data.valueSquared / count - avg * avg);
            return (long)stddev;
        }

        private void checkState() {
            if (this.entry == null) {
                throw new IllegalStateException();
            }
        }
    }

    private static class Data {
        long count;
        long value;
        long minValue;
        long maxValue;
        long valueSquared;

        public Data() {
            this.minValue = Long.MAX_VALUE;
            this.maxValue = Long.MIN_VALUE;
        }

        public Data(Data src) {
            this.count = src.count;
            this.value = src.value;
            this.minValue = src.minValue;
            this.maxValue = src.maxValue;
            this.valueSquared = src.valueSquared;
        }

        public void increment(long delta) {
            ++this.count;
            this.value += delta;
            this.valueSquared += delta * delta;
            if (this.minValue > delta) {
                this.minValue = delta;
            }
            if (this.maxValue < delta) {
                this.maxValue = delta;
            }
        }

        public void update(Data src) {
            this.count += src.count;
            this.value += src.value;
            this.valueSquared += src.valueSquared;
            if (this.maxValue < src.maxValue) {
                this.maxValue = src.maxValue;
            }
            if (this.minValue > src.minValue) {
                this.minValue = src.minValue;
            }
        }
    }
}

