/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.Aggregator;
import com.cognos.cm.diagnostics.CounterDescriptor;
import com.cognos.cm.diagnostics.History;
import com.cognos.cm.diagnostics.ReportGenerator;
import com.cognos.cm.diagnostics.ReportTarget;
import com.cognos.cm.diagnostics.serialization.CounterSerializer;
import com.cognos.cm.diagnostics.serialization.CounterSerializerFactory;
import com.cognos.cm.util.csv.CSVUtils;

public class CSVReportGenerator
extends ReportGenerator {
    protected StringBuffer buffer = new StringBuffer();
    protected boolean printHeader = false;
    private String header;
    private String entryPrefix;

    public CSVReportGenerator(ReportTarget target, CounterSerializer serializer, boolean hasGroups) {
        super(target, serializer, hasGroups);
    }

    @Override
    public void print(CounterDescriptor[] descriptors, String group, History.Interval interval) {
        this.buffer.setLength(0);
        if (this.hasGroups) {
            this.buffer.append(CSVUtils.encodeData((String)group)).append(",");
        }
        this.buffer.append(this.makeTime(interval.timestamp)).append(",");
        String counterPrefix = this.buffer.toString();
        for (int i = 0; i < interval.counters.length; ++i) {
            this.buffer.setLength(0);
            this.buffer.append(counterPrefix);
            this.buffer.append(descriptors[i].getName()).append(",");
            this.serializer.serialize(interval.counters[i], this);
            if (this.buffer.length() == 0) continue;
            if (this.buffer.charAt(this.buffer.length() - 1) == ',') {
                this.buffer.setCharAt(this.buffer.length() - 1, '\n');
            }
            this.target_.print(this.buffer.toString());
        }
    }

    @Override
    public void beginEntries() {
        this.entryPrefix = this.buffer.toString();
        this.buffer.setLength(0);
    }

    @Override
    public void beginEntry() {
        this.buffer.append(this.entryPrefix);
    }

    @Override
    public void printField(String fieldName, long value) {
        this.buffer.append(Long.toString(value)).append(",");
    }

    @Override
    public void printField(String fieldName, double value) {
        this.buffer.append(Double.toString(value)).append(",");
    }

    @Override
    public void printField(String fieldName, String value) {
        this.buffer.append(CSVUtils.encodeData((String)value)).append(",");
    }

    @Override
    public void endEntry() {
        this.buffer.setCharAt(this.buffer.length() - 1, '\n');
    }

    @Override
    public void endEntries() {
        this.entryPrefix = null;
    }

    @Override
    public String getFooter() {
        return null;
    }

    @Override
    public String getHeader() {
        if (this.header != null) {
            return this.header;
        }
        this.header = CSVReportGenerator.generateHeader(this.serializer.getFields(), this.hasGroups);
        return this.header;
    }

    public static String generateHeaderFor(Aggregator agg) {
        CounterSerializer serializer = CounterSerializerFactory.getSerializerForType(agg.getCounterType());
        return CSVReportGenerator.generateHeader(serializer.getFields(), agg.hasGroups());
    }

    public static String generateHeader(String[] headers, boolean hasGroups) {
        StringBuffer buffer = new StringBuffer();
        if (hasGroups) {
            buffer.append("group,");
        }
        buffer.append("time,counter,");
        for (String header : headers) {
            buffer.append(header).append(",");
        }
        buffer.setCharAt(buffer.length() - 1, '\n');
        return buffer.toString();
    }
}

