/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.ibm.bi.cognos.shaded.org.apache.log.output.io.rotate.FileStrategy;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class CappedDatedFileStrategy
implements FileStrategy {
    private static final String FORMAT_STRING = "yyyy-MM-dd";
    public static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String DATE_SEP = "_";
    private String prefix;
    private String extension;
    private File directory;
    private int maxFiles;

    public CappedDatedFileStrategy(File directory, String prefix, String extension, int maxFiles) {
        this.directory = directory;
        this.prefix = prefix;
        this.extension = extension;
        this.maxFiles = maxFiles;
    }

    public File nextFile() {
        if (this.maxFiles > 0) {
            this.deleteOldFiles();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.prefix).append(DATE_SEP).append(FORMAT.format(this.getDate())).append(this.extension);
        return new File(this.directory, buffer.toString());
    }

    private void deleteOldFiles() {
        Object[] existingFiles = CappedDatedFileStrategy.getExistingFileNames(this.directory, this.prefix, this.extension);
        if (existingFiles.length >= this.maxFiles) {
            Arrays.sort(existingFiles);
            int needToDelete = existingFiles.length - this.maxFiles;
            for (int i = 0; i < needToDelete; ++i) {
                File toDelete = new File(this.directory, (String)existingFiles[i]);
                toDelete.delete();
            }
        }
    }

    public static String[] getExistingFileNames(File directory, final String prefix, final String extension) {
        String[] results = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(extension) && name.length() == prefix.length() + CappedDatedFileStrategy.DATE_SEP.length() + extension.length() + CappedDatedFileStrategy.FORMAT_STRING.length();
            }
        });
        return results;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getExtension() {
        return this.extension;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    protected Date getDate() {
        return new Date();
    }
}

