/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.DiagnosticsContext;
import java.util.HashMap;
import java.util.Map;

public class ContextFilter {
    protected HashMap<DiagnosticsContext.Param, String[]> filters = new HashMap();

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public void set(DiagnosticsContext.Param key, String ... values) {
        String[] lowCaseCopy = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            lowCaseCopy[i] = values[i].toLowerCase();
        }
        this.filters.put(key, lowCaseCopy);
    }

    public DiagnosticsContext.Param[] getFilterParameters() {
        DiagnosticsContext.Param[] result = new DiagnosticsContext.Param[this.filters.size()];
        this.filters.keySet().toArray(result);
        return result;
    }

    public String[] getFilterValues(DiagnosticsContext.Param param) {
        return this.filters.get((Object)param);
    }

    public boolean match(DiagnosticsContext ctx) {
        if (this.filters.isEmpty()) {
            return true;
        }
        Boolean match = ctx.getFilterResult(this);
        if (match != null) {
            return match;
        }
        match = Boolean.TRUE;
        for (Map.Entry<DiagnosticsContext.Param, String[]> entry : this.filters.entrySet()) {
            String value = ctx.get(entry.getKey());
            if (value == null) {
                return false;
            }
            match = ContextFilter.arrayContains(entry.getValue(), value);
            if (match == Boolean.TRUE) continue;
            break;
        }
        ctx.setFilterResult(this, match);
        return match;
    }

    private static Boolean arrayContains(String[] array, String value) {
        Boolean match = Boolean.FALSE;
        for (int i = 0; i < array.length; ++i) {
            if (!value.equals(array[i])) continue;
            match = Boolean.TRUE;
            break;
        }
        return match;
    }
}

