/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.Counter;
import java.lang.reflect.Field;

public class CounterDescriptor {
    private final String name;
    private final String description;
    private final String target;
    private Counter counter = null;

    public CounterDescriptor(String name, String description, String target) {
        this.name = name;
        this.description = description;
        this.target = target;
    }

    public CounterDescriptor(String name, String description, Counter counter) {
        this.name = name;
        this.description = description;
        this.target = null;
        this.counter = counter;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends Counter> getType() {
        return this.getCounter().getType();
    }

    public String getTypeName() {
        Class<? extends Counter> c = this.getType();
        String name = c.getSimpleName();
        if (name.endsWith("Counter")) {
            return name.substring(0, name.length() - 7);
        }
        return name;
    }

    public Counter getCounter() {
        if (this.counter == null) {
            this.counter = this.locateTarget();
        }
        return this.counter;
    }

    public Counter getCounter(boolean resolve) {
        if (this.counter == null && resolve) {
            this.counter = this.locateTarget();
        }
        return this.counter;
    }

    private Counter locateTarget() {
        int n = this.target.lastIndexOf(46);
        String declaringClass = this.target.substring(0, n);
        String fieldName = this.target.substring(n + 1);
        try {
            Class<?> parent = Class.forName(declaringClass);
            Field field = parent.getField(fieldName);
            return (Counter)field.get(null);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

