/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.Aggregator;
import com.cognos.cm.diagnostics.DiagnosticsManager;
import com.cognos.cm.diagnostics.LogKitTarget;
import com.cognos.cm.diagnostics.ReadyToGraphCSVReportGenerator;
import com.cognos.cm.diagnostics.serialization.CounterSerializer;
import com.cognos.cm.diagnostics.serialization.CounterSerializerFactory;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.util.CMEnvironment;
import com.ibm.bi.cognos.shaded.org.apache.log.Hierarchy;
import com.ibm.bi.cognos.shaded.org.apache.log.Logger;
import java.io.IOException;

public class DiagnosticsConfiguration {
    private static boolean configured = false;
    private static final String[] classes = new String[]{"server.ContentManager", "cam.AAACounterProxy"};
    private static final String CM_METRICS_DEFAULT_FILE = "cmMetrics";

    public static void configure() {
        if (configured) {
            return;
        }
        for (int i = 0; i < classes.length; ++i) {
            String cls = classes[i];
            if (!cls.startsWith("com.")) {
                cls = "com.cognos.cm." + cls;
            }
            try {
                Class.forName(cls, true, DiagnosticsConfiguration.class.getClassLoader());
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void systemConfigurationLoaded() {
        DiagnosticsConfiguration.constructDefaultAggregator();
    }

    private static void constructDefaultAggregator() {
        DiagnosticsManager diagMgr = ContentManager.diagnosticsManager;
        Aggregator agg = new Aggregator("##CMDefaultMeasure", diagMgr.getCounterDescriptor("CM.TOTAL"), diagMgr.getCounterDescriptor("CM.DB"), diagMgr.getCounterDescriptor("CM.CAM"));
        ReadyToGraphCSVReportGenerator reporter = null;
        try {
            Logger myLogger = Hierarchy.getDefaultHierarchy().getLoggerFor("com.cognos.cm");
            String header = ReadyToGraphCSVReportGenerator.generateHeaderFor(agg);
            String footer = null;
            LogKitTarget target = new LogKitTarget(myLogger, CMEnvironment.getCRNLogsDir(), CM_METRICS_DEFAULT_FILE, ".log", 7, 1, header, footer);
            CounterSerializer serializer = CounterSerializerFactory.getSerializerForType(agg.getCounterType());
            reporter = new ReadyToGraphCSVReportGenerator(target, serializer, agg.getCounters(), agg.hasGroups());
            agg.setReportGenerator(reporter);
        }
        catch (IOException ioe) {
            CMIndications.logException(new CMException((Exception)ioe, "cmErrorLoggingDefaultMeasure", new CMException.Parm("measureName", "##CMDefaultMeasure")));
        }
        diagMgr.registerAggregator(agg);
    }
}

