/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.ContextFilter;
import java.util.HashMap;

public class DiagnosticsContext {
    protected static final ThreadLocal<DiagnosticsContext> tls = new ThreadLocal<DiagnosticsContext>(){

        @Override
        public DiagnosticsContext initialValue() {
            return new DiagnosticsContext();
        }
    };
    protected HashMap<String, String> map = new HashMap();
    protected HashMap<ContextFilter, Boolean> filterCache = new HashMap();

    public String get(String key) {
        return this.map.get(key);
    }

    public String get(Param key) {
        return this.map.get(key.toString());
    }

    public void set(String key, String value) {
        if (value != null) {
            this.map.put(key, value.toLowerCase());
        } else {
            this.map.remove(key);
        }
    }

    public void set(Param key, String value) {
        if (value != null) {
            this.map.put(key.toString(), value.toLowerCase());
        } else {
            this.map.remove(key.toString());
        }
    }

    public void setUser(String user) {
        this.set(Param.USER, user);
    }

    public void setRequester(String requester) {
        this.set(Param.REQUESTER, requester);
    }

    public void setComponent(String component) {
        this.set(Param.COMPONENT, component);
    }

    public void setRequest(String request) {
        this.set(Param.REQUEST, request);
    }

    public void setCommand(String command) {
        this.set(Param.COMMAND, command);
    }

    public static DiagnosticsContext get() {
        return tls.get();
    }

    public void reset() {
        this.map.clear();
        this.filterCache.clear();
    }

    public static Param getParam(String name) {
        try {
            return Param.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public DiagnosticsContext save() {
        DiagnosticsContext clone = new DiagnosticsContext();
        clone.map.putAll(this.map);
        return clone;
    }

    public void restore(DiagnosticsContext ctx) {
        this.reset();
        this.map.putAll(ctx.map);
    }

    protected Boolean getFilterResult(ContextFilter filter) {
        return this.filterCache.get(filter);
    }

    protected void setFilterResult(ContextFilter filter, Boolean result) {
        this.filterCache.put(filter, result);
    }

    public static enum Param {
        USER,
        REQUESTER,
        COMPONENT,
        REQUEST,
        COMMAND;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

