/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.AbstractCounter;
import com.cognos.cm.diagnostics.Aggregator;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.CounterDescriptor;
import com.cognos.cm.diagnostics.DiagnosticsContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DiagnosticsManager {
    protected String registryDefault = System.getProperty("com.cognos.cm.diagnostics.DiagnosticsManager.registryDefault", null);
    protected HashMap<String, CounterDescriptor> counters = new HashMap();
    protected HashMap<String, Aggregator> aggregators = new HashMap();
    protected Object mutex = new Object();

    public DiagnosticsManager() {
    }

    public DiagnosticsManager(Class<?> resourceLocation) {
        this.loadRegistry(resourceLocation);
    }

    public void loadRegistry(Class<?> resourceLocation) {
        InputStream is = resourceLocation.getResourceAsStream("CounterRegistry.xml");
        if (is == null && this.registryDefault != null) {
            this.log("Cannot load CounterRegistry.xml. Loading CounterRegistry_default.xml.");
            is = resourceLocation.getResourceAsStream(this.registryDefault);
        }
        this.loadCounters(is);
    }

    private void log(String message) {
        System.err.println(this.getClass().getName() + ":WARN " + message);
    }

    protected void loadCounters(InputStream is) {
        if (is == null) {
            return;
        }
        SAXReader reader = new SAXReader();
        try {
            Element root = reader.read(is).getRootElement();
            for (Element el : root.elements()) {
                CounterDescriptor d = new CounterDescriptor(el.attributeValue("name"), el.elementText("description"), el.elementText("target"));
                this.registerCounter(d);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCounter(CounterDescriptor counter) {
        String counterName = counter.getName().toLowerCase();
        Object object = this.mutex;
        synchronized (object) {
            CounterDescriptor old = this.counters.get(counterName);
            if (old != null) {
                throw new IllegalStateException("Counter \"" + counter.getName() + "\" is already registered");
            }
            this.counters.put(counterName, counter);
        }
    }

    public Counter getCounter(String name) {
        return this.getCounterDescriptor(name).getCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CounterDescriptor getCounterDescriptor(String name) {
        Object object = this.mutex;
        synchronized (object) {
            return this.counters.get(name.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAggregator(Aggregator aggregator) {
        String aggregatorName = aggregator.getName().toLowerCase();
        Object object = this.mutex;
        synchronized (object) {
            Aggregator old = this.aggregators.get(aggregatorName);
            if (old != null) {
                throw new IllegalStateException("Aggregator \"" + aggregator.getName() + "\" is already registered");
            }
            this.aggregators.put(aggregatorName, aggregator);
        }
        aggregator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregator getAggregator(String name) {
        Object object = this.mutex;
        synchronized (object) {
            return this.aggregators.get(name.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAggregator(String name) {
        Aggregator agg = null;
        Object object = this.mutex;
        synchronized (object) {
            agg = this.aggregators.remove(name.toLowerCase());
        }
        if (agg != null) {
            agg.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CounterDescriptor> listCounters() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList<CounterDescriptor>(this.counters.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Aggregator> listAggregators() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList<Aggregator>(this.aggregators.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        String command = DiagnosticsContext.get().get(DiagnosticsContext.Param.COMMAND);
        if (!this.isAuxiliaryMethod(command)) {
            long now = System.currentTimeMillis();
            Object object = this.mutex;
            synchronized (object) {
                for (Aggregator aggregator : this.aggregators.values()) {
                    aggregator.update(now);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DiagnosticsContext.get().reset();
        Object object = this.mutex;
        synchronized (object) {
            for (CounterDescriptor desc : this.counters.values()) {
                Counter counter = desc.getCounter(false);
                if (!(counter instanceof AbstractCounter.ThreadLocalCounter)) continue;
                counter.reset();
            }
        }
    }

    private boolean isAuxiliaryMethod(String command) {
        return "diagnostics".equals(command);
    }
}

