/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.ibm.bi.cognos.shaded.org.apache.log.format.Formatter;
import com.ibm.bi.cognos.shaded.org.apache.log.output.io.FileTarget;
import com.ibm.bi.cognos.shaded.org.apache.log.output.io.rotate.FileStrategy;
import com.ibm.bi.cognos.shaded.org.apache.log.output.io.rotate.RotateStrategy;
import java.io.File;
import java.io.IOException;

public class HeaderFooterRotatingFileTarget
extends FileTarget {
    private RotateStrategy rotateStrategy;
    private FileStrategy fileStrategy;
    private String header;
    private String footer;

    public HeaderFooterRotatingFileTarget(Formatter formatter, RotateStrategy rotateStrategy, FileStrategy fileStrategy, String header, String footer) throws IOException {
        super(null, false, formatter);
        this.rotateStrategy = rotateStrategy;
        this.fileStrategy = fileStrategy;
        this.header = header;
        this.footer = footer;
        this.openNewFile();
        this.writeHeader();
    }

    private void writeHeader() {
        if (this.header != null) {
            super.write(this.header);
        }
    }

    private void writeFooter() {
        if (this.footer != null) {
            super.write(this.footer);
        }
    }

    private void openNewFile() throws IOException {
        File newFile = this.fileStrategy.nextFile();
        this.setFile(newFile, false);
        this.openFile();
    }

    protected void rotate() throws IOException {
        this.close();
        this.openNewFile();
        this.writeHeader();
    }

    protected synchronized void write(String data) {
        if (this.rotateStrategy.isRotationNeeded(data, this.getFile())) {
            try {
                this.rotate();
                this.rotateStrategy.reset();
            }
            catch (IOException e) {
                this.getErrorHandler().error("Unable to rotate file", (Throwable)e, null);
            }
        }
        super.write(data);
    }

    public synchronized void close() {
        this.writeFooter();
        super.close();
    }
}

