/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.Counter;
import java.util.ArrayList;
import java.util.List;

public class History {
    protected Counter[] counters;
    protected Interval[] intervals;
    protected int head;
    protected int tail;
    protected long intervalDuration;

    public History(Counter[] counters, long intervalDuration, int numberOfIntervals, long timestamp) {
        if (numberOfIntervals < 1) {
            throw new IllegalArgumentException("invalid number of intervals");
        }
        this.counters = counters;
        this.intervalDuration = intervalDuration;
        this.createIntervalQueue(numberOfIntervals, counters, timestamp);
    }

    public int getNumberOfIntervals() {
        return this.intervals.length;
    }

    public long getIntervalDuration() {
        return this.intervalDuration;
    }

    public Interval update(long timestamp, boolean returnInterval) {
        Interval previousInterval = this.adjustQueue(timestamp, returnInterval);
        this.intervals[this.head].update(this.counters);
        return previousInterval;
    }

    public Interval getCurrentInterval() {
        return new Interval(this.intervals[this.head]);
    }

    public List<Interval> getIntervals() {
        ArrayList<Interval> list = new ArrayList<Interval>(this.intervals.length);
        int pos = this.tail;
        while (true) {
            list.add(new Interval(this.intervals[pos]));
            if (pos == this.head) break;
            if (++pos != this.intervals.length) continue;
            pos = 0;
        }
        return list;
    }

    private void createIntervalQueue(int numberOfIntervals, Counter[] counters, long timestamp) {
        this.intervals = new Interval[numberOfIntervals];
        for (int i = 0; i < numberOfIntervals; ++i) {
            this.intervals[i] = new Interval(counters);
        }
        this.tail = 0;
        this.head = 0;
        this.intervals[this.head].timestamp = timestamp;
    }

    private Interval adjustQueue(long timestamp, boolean returnInterval) {
        Interval previousInterval = null;
        if (timestamp - this.intervals[this.head].timestamp >= this.intervalDuration) {
            long n = (timestamp - this.intervals[this.head].timestamp) / this.intervalDuration;
            timestamp = this.intervals[this.head].timestamp + n * this.intervalDuration;
            if (returnInterval) {
                previousInterval = new Interval(this.intervals[this.head]);
            }
            ++this.head;
            if (this.head == this.intervals.length) {
                this.head = 0;
            }
            this.intervals[this.head].reset(timestamp);
            this.adjustTail();
        }
        return previousInterval;
    }

    private void adjustTail() {
        if (this.tail == this.head) {
            ++this.tail;
            if (this.tail == this.intervals.length) {
                this.tail = 0;
            }
        }
        long timestamp = this.intervals[this.head].timestamp - (long)(this.intervals.length - 1) * this.intervalDuration;
        while (this.intervals[this.tail].timestamp < timestamp) {
            ++this.tail;
            if (this.tail != this.intervals.length) continue;
            this.tail = 0;
        }
    }

    public static class Interval {
        public long timestamp;
        public Counter[] counters;

        protected Interval(Counter[] counters) {
            this.counters = new Counter[counters.length];
            for (int i = 0; i < counters.length; ++i) {
                this.counters[i] = counters[i].newInstance();
            }
        }

        protected Interval(Interval src) {
            this.timestamp = src.timestamp;
            this.counters = new Counter[src.counters.length];
            for (int i = 0; i < this.counters.length; ++i) {
                this.counters[i] = src.counters[i].newInstance();
                this.counters[i].update(src.counters[i].getState());
            }
        }

        protected void update(Counter[] counters) {
            for (int i = 0; i < counters.length; ++i) {
                this.counters[i].update(counters[i].getState());
            }
        }

        protected void reset(long timestamp) {
            this.timestamp = timestamp;
            for (int i = 0; i < this.counters.length; ++i) {
                this.counters[i].reset();
            }
        }
    }
}

