/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.AbstractReportTarget;
import com.cognos.cm.diagnostics.CappedDatedFileStrategy;
import com.cognos.cm.diagnostics.HeaderFooterRotatingFileTarget;
import com.ibm.bi.cognos.shaded.org.apache.log.Hierarchy;
import com.ibm.bi.cognos.shaded.org.apache.log.LogTarget;
import com.ibm.bi.cognos.shaded.org.apache.log.Logger;
import com.ibm.bi.cognos.shaded.org.apache.log.Priority;
import com.ibm.bi.cognos.shaded.org.apache.log.format.Formatter;
import com.ibm.bi.cognos.shaded.org.apache.log.format.PatternFormatter;
import com.ibm.bi.cognos.shaded.org.apache.log.output.io.rotate.RotateStrategy;
import com.ibm.bi.cognos.shaded.org.apache.log.output.io.rotate.RotateStrategyByTime;
import java.io.File;
import java.io.IOException;

public class LogKitTarget
extends AbstractReportTarget {
    public static final String CM_LOGGER_CATEGORY = "com.cognos.cm";
    private Logger logger;
    private int daysPerFile;
    private CappedDatedFileStrategy strategy;
    private HeaderFooterRotatingFileTarget loggerTarget;

    public LogKitTarget(String name, File logsDir, String fileName, String fileExtension, int maxFiles, int daysPerFile, String header, String footer) throws IOException {
        this(Hierarchy.getDefaultHierarchy().getLoggerFor("com.cognos.cm." + name), logsDir, fileName, fileExtension, maxFiles, daysPerFile, header, footer);
    }

    public LogKitTarget(Logger logger, File logsDir, String fileName, String fileExtension, int maxFiles, int daysPerFile, String header, String footer) throws IOException {
        this.logger = logger;
        logger.setPriority(Priority.INFO);
        this.daysPerFile = daysPerFile;
        this.setupLogTarget(logsDir, fileName, fileExtension, maxFiles, header, footer);
    }

    private void setupLogTarget(File directory, String fileName, String fileExtension, int maxFiles, String header, String footer) throws IOException {
        this.strategy = new CappedDatedFileStrategy(directory, fileName, fileExtension, maxFiles);
        NeverRotateStrategy rotateStrategy = this.daysPerFile <= 0 ? new NeverRotateStrategy() : new RotateStrategyByTime((long)(86400000 * this.daysPerFile));
        this.loggerTarget = new HeaderFooterRotatingFileTarget((Formatter)new PatternFormatter("%{message}"), rotateStrategy, this.strategy, header, footer);
        this.logger.setLogTargets(new LogTarget[]{this.loggerTarget});
    }

    @Override
    public void print(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void close() {
        this.logger.unsetLogTargets();
        this.loggerTarget.close();
    }

    @Override
    public String getName() {
        return this.getFileName();
    }

    public String getFileName() {
        return this.strategy.getPrefix();
    }

    public int getMaxFiles() {
        return this.strategy.getMaxFiles();
    }

    public int getDaysPerFile() {
        return this.daysPerFile;
    }

    private class NeverRotateStrategy
    implements RotateStrategy {
        private NeverRotateStrategy() {
        }

        public boolean isRotationNeeded(String arg0, File arg1) {
            return false;
        }

        public void reset() {
        }
    }
}

