/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.AbstractCounter;
import com.cognos.cm.diagnostics.Counter;

public class MinMaxCounter
extends AbstractCounter {
    protected long value;
    protected long minValue;
    protected long maxValue;

    @Override
    public Counter getState() {
        MinMaxCounter result = new MinMaxCounter();
        result.value = this.value;
        result.maxValue = this.maxValue;
        result.minValue = this.minValue;
        return result;
    }

    @Override
    public void increment(long delta, Object data) {
        this.increment(delta);
    }

    @Override
    public void increment(long delta) {
        this.value += delta;
        if (this.minValue > this.value) {
            this.minValue = this.value;
        }
        if (this.maxValue < this.value) {
            this.maxValue = this.value;
        }
    }

    @Override
    public Counter newInstance() {
        MinMaxCounter result = new MinMaxCounter();
        result.value = this.value;
        result.reset();
        return result;
    }

    @Override
    public void reset() {
        this.minValue = this.maxValue = this.value;
    }

    @Override
    public void update(Counter state) {
        if (!(state instanceof MinMaxCounter)) {
            throw new IllegalArgumentException();
        }
        this.value = ((MinMaxCounter)state).value;
        this.minValue = ((MinMaxCounter)state).minValue;
        this.maxValue = ((MinMaxCounter)state).maxValue;
    }

    public long getValue() {
        return this.value;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }
}

