/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.Aggregator;
import com.cognos.cm.diagnostics.CSVReportGenerator;
import com.cognos.cm.diagnostics.CounterDescriptor;
import com.cognos.cm.diagnostics.History;
import com.cognos.cm.diagnostics.ReportTarget;
import com.cognos.cm.diagnostics.serialization.CounterSerializer;
import com.cognos.cm.diagnostics.serialization.CounterSerializerFactory;

public class ReadyToGraphCSVReportGenerator
extends CSVReportGenerator {
    private CounterDescriptor[] descriptors;

    public ReadyToGraphCSVReportGenerator(ReportTarget target, CounterSerializer serializer, CounterDescriptor[] descriptors, boolean hasGroups) {
        super(target, serializer, hasGroups);
        if (hasGroups) {
            throw new RuntimeException("Ready to graph report does not support grouping");
        }
        if (serializer.hasEntries()) {
            throw new RuntimeException("Ready to graph report does not support counters which have entries");
        }
        this.descriptors = descriptors;
    }

    @Override
    public String getHeader() {
        return ReadyToGraphCSVReportGenerator.generateHeader(this.serializer.getFields(), this.descriptors);
    }

    public static String generateHeaderFor(Aggregator agg) {
        CounterSerializer serializer = CounterSerializerFactory.getSerializerForType(agg.getCounterType());
        return ReadyToGraphCSVReportGenerator.generateHeader(serializer.getFields(), agg.getCounters());
    }

    public static String generateHeader(String[] headers, CounterDescriptor[] descriptors) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("time,");
        for (CounterDescriptor descriptor : descriptors) {
            String counterName = descriptor.getName();
            for (String field : headers) {
                buffer.append(counterName).append("-").append(field).append(",");
            }
        }
        buffer.setCharAt(buffer.length() - 1, '\n');
        return buffer.toString();
    }

    @Override
    public void print(CounterDescriptor[] descriptors, String group, History.Interval interval) {
        if (group != null && !group.equals("")) {
            throw new RuntimeException("Ready to graph report does not support grouping");
        }
        this.buffer.setLength(0);
        this.buffer.append(this.makeTime(interval.timestamp)).append(",");
        for (int i = 0; i < interval.counters.length; ++i) {
            this.serializer.serialize(interval.counters[i], this);
        }
        this.buffer.setCharAt(this.buffer.length() - 1, '\n');
        this.target_.print(this.buffer.toString());
    }

    @Override
    public void beginEntries() {
        throw new UnsupportedOperationException("Unsupported operation: beginEntries()");
    }

    @Override
    public void beginEntry() {
        throw new UnsupportedOperationException("Unsupported operation: beginEntry()");
    }

    @Override
    public void endEntries() {
        throw new UnsupportedOperationException("Unsupported operation: endEntries()");
    }

    @Override
    public void endEntry() {
        throw new UnsupportedOperationException("Unsupported operation: endEntry()");
    }
}

