/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.CounterDescriptor;
import com.cognos.cm.diagnostics.History;
import com.cognos.cm.diagnostics.ReportTarget;
import com.cognos.cm.diagnostics.serialization.CounterPrinter;
import com.cognos.cm.diagnostics.serialization.CounterSerializer;
import com.cognos.cmutils.date.DateUtils;
import java.util.Calendar;

public abstract class ReportGenerator
implements CounterPrinter {
    protected ReportTarget target_;
    protected Calendar calendar = Calendar.getInstance();
    protected CounterSerializer serializer;
    protected boolean hasGroups;

    public ReportGenerator(ReportTarget target, CounterSerializer serializer, boolean hasGroups) {
        this.target_ = target;
        this.serializer = serializer;
        this.hasGroups = hasGroups;
    }

    public void close() {
        this.target_.close();
    }

    public ReportTarget getReportTarget() {
        return this.target_;
    }

    protected String makeTime(long timestamp) {
        this.calendar.setTimeInMillis(timestamp);
        return DateUtils.getIsoDate((Calendar)this.calendar);
    }

    @Override
    public void printHeader() {
        String header = this.getHeader();
        if (header != null) {
            this.target_.print(header);
        }
    }

    @Override
    public void printFooter() {
        String footer = this.getFooter();
        if (footer != null) {
            this.target_.print(this.getFooter());
        }
    }

    public abstract String getHeader();

    public abstract String getFooter();

    public abstract void print(CounterDescriptor[] var1, String var2, History.Interval var3);
}

