/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.util.clock.HighResClock;
import com.cognos.cm.util.clock.NanoClock;

public class Timer {
    protected static HighResClock clock = new NanoClock();
    protected Counter counter;
    protected ThreadLocal<State> tls;

    public Timer(Counter counter) {
        this.counter = counter;
        this.tls = new ThreadLocal<State>(){

            @Override
            protected State initialValue() {
                return new State();
            }
        };
    }

    public void start() {
        State state = this.tls.get();
        state.started = true;
        state.start = clock.getTicks();
    }

    public void stop(Object data) {
        State state = this.tls.get();
        if (state.started) {
            this.counter.increment(clock.getTicks() - state.start, data);
            state.started = false;
        }
    }

    public void stop() {
        State state = this.tls.get();
        if (state.started) {
            this.counter.increment(clock.getTicks() - state.start);
            state.started = false;
        }
    }

    private static class State {
        long start;
        boolean started;

        private State() {
        }
    }
}

