/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.AbstractCounter;
import com.cognos.cm.diagnostics.Counter;

public class TopTenCounter
extends AbstractCounter {
    public final int maxEntries;
    protected Entry[] entries;

    public TopTenCounter(int maxEntries) {
        this.maxEntries = maxEntries;
        this.entries = new Entry[maxEntries];
        for (int i = 0; i < maxEntries; ++i) {
            this.entries[i] = new Entry();
        }
    }

    @Override
    public Counter getState() {
        TopTenCounter result = new TopTenCounter(this.maxEntries);
        result.copyEntries(this);
        return result;
    }

    @Override
    public void increment(long delta, Object data) {
        if (delta < this.entries[0].value) {
            return;
        }
        int mid = this.search(delta, 0, this.maxEntries - 1);
        this.insertAt(mid, delta, data);
    }

    @Override
    public void increment(long delta) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.maxEntries; ++i) {
            this.entries[i].value = 0L;
            this.entries[i].data = null;
        }
    }

    @Override
    public void update(Counter state) {
        if (!(state instanceof TopTenCounter)) {
            throw new IllegalArgumentException("state is not instance of TopTenCounter");
        }
        TopTenCounter other = (TopTenCounter)state;
        if (other.entries[other.maxEntries - 1].value < this.entries[0].value) {
            return;
        }
        if (other.entries[0].value > this.entries[this.maxEntries - 1].value) {
            this.copyEntries(other);
        } else {
            this.insertEntries(other);
        }
    }

    private int search(long value, int low, int high) {
        for (int i = low; i <= high; ++i) {
            if (this.entries[i].value <= value) continue;
            return i == low ? low : i - 1;
        }
        return high;
    }

    private void insertAt(int pos, long delta, Object data) {
        for (int i = 0; i < pos; ++i) {
            this.entries[i].value = this.entries[i + 1].value;
            this.entries[i].data = this.entries[i + 1].data;
        }
        this.entries[pos].value = delta;
        this.entries[pos].data = data;
    }

    private void insertEntries(TopTenCounter other) {
        int n = Math.min(this.maxEntries, other.maxEntries);
        int high = this.maxEntries - 1;
        int idx = other.maxEntries - 1;
        for (int i = 0; i < n; ++i) {
            Entry otherEntry = other.entries[idx--];
            int pos = this.search(otherEntry.value, 0, high);
            this.insertAt(pos, otherEntry.value, otherEntry.data);
            if (pos == 0) break;
            high = pos - 1;
        }
    }

    private void copyEntries(TopTenCounter other) {
        int n = Math.min(this.maxEntries, other.maxEntries);
        if (n < this.maxEntries) {
            int d = this.maxEntries - n;
            for (int i = 1; i <= d; ++i) {
                this.entries[d - i].value = this.entries[this.maxEntries - i].value;
                this.entries[d - i].data = this.entries[this.maxEntries - i].data;
            }
        }
        int i1 = this.maxEntries - 1;
        int i2 = other.maxEntries - 1;
        for (int i = 0; i < n; ++i) {
            this.entries[i1].value = other.entries[i2].value;
            this.entries[i1--].data = other.entries[i2--].data;
        }
    }

    @Override
    public Counter newInstance() {
        return new TopTenCounter(this.maxEntries);
    }

    public Entry getEntry(int n) {
        return this.entries[this.maxEntries - n - 1];
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public static class Entry {
        public long value;
        public Object data;
    }
}

