/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics;

import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.CounterDescriptor;
import com.cognos.cm.diagnostics.History;
import com.cognos.cm.diagnostics.ReportGenerator;
import com.cognos.cm.diagnostics.ReportTarget;
import com.cognos.cm.diagnostics.serialization.CounterSerializer;
import com.cognos.cmutils.xml.XMLUtils;

public class XMLReportGenerator
extends ReportGenerator {
    public static final String HEADER = "<report>\n";
    public static final String FOOTER = "</report>\n";
    private String fieldIndent = "";
    private StringBuffer sb_ = new StringBuffer();

    public XMLReportGenerator(ReportTarget target, CounterSerializer serializer, boolean hasGroups) {
        super(target, serializer, hasGroups);
    }

    @Override
    public String getHeader() {
        return HEADER;
    }

    @Override
    public String getFooter() {
        return FOOTER;
    }

    @Override
    public void print(CounterDescriptor[] descriptors, String group, History.Interval interval) {
        for (int i = 0; i < interval.counters.length; ++i) {
            this.target_.print("\t<entry>\n");
            if (group != null) {
                this.target_.print("\t\t<group>" + XMLUtils.escape((String)group) + "</group>\n");
            }
            this.target_.print("\t\t<interval>" + this.makeTime(interval.timestamp) + "</interval>\n");
            this.serializeCounter(descriptors[i].getName(), interval.counters[i]);
            this.target_.print("\t</entry>\n");
        }
    }

    private void serializeCounter(String name, Counter counter) {
        this.sb_.setLength(0);
        this.sb_.append("\t\t<counter>\n\t\t\t<name>").append(name).append("</name>\n");
        this.target_.print(this.sb_.toString());
        this.serializer.serialize(counter, this);
        this.target_.print("\t\t</counter>\n");
    }

    @Override
    public void beginEntries() {
        this.target_.print("\t\t\t<entries>\n");
    }

    @Override
    public void beginEntry() {
        this.target_.print("\t\t\t\t<item>\n");
        this.fieldIndent = "\t\t";
    }

    @Override
    public void printField(String fieldName, long value) {
        this.printField(fieldName, Long.toString(value));
    }

    @Override
    public void printField(String fieldName, double value) {
        this.printField(fieldName, Double.toString(value));
    }

    @Override
    public void printField(String fieldName, String value) {
        this.sb_.setLength(0);
        this.sb_.append("\t\t\t").append(this.fieldIndent).append("<").append(fieldName).append(">").append(value).append("</").append(fieldName).append(">\n");
        this.target_.print(this.sb_.toString());
    }

    @Override
    public void endEntry() {
        this.target_.print("\t\t\t\t</item>\n");
        this.fieldIndent = "";
    }

    @Override
    public void endEntries() {
        this.target_.print("\t\t\t</entries>\n");
    }
}

