/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics.serialization;

import com.cognos.cm.diagnostics.AllInOneCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.serialization.CounterPrinter;
import com.cognos.cm.diagnostics.serialization.CounterSerializer;

public class AllInOneCounterSerializer
implements CounterSerializer {
    public static final String[] FIELDS = new String[]{"value", "callCount", "minValue", "maxValue", "stdDev", "data"};

    @Override
    public String[] getFields() {
        return FIELDS;
    }

    @Override
    public boolean hasEntries() {
        return true;
    }

    @Override
    public void serialize(Counter counter, CounterPrinter printer) {
        if (!(counter instanceof AllInOneCounter)) {
            throw new IllegalArgumentException("Counter must be of class " + AllInOneCounter.class.getName());
        }
        AllInOneCounter allInOneCounter = (AllInOneCounter)counter;
        printer.beginEntries();
        AllInOneCounter.Iterator iterator = allInOneCounter.entries();
        while (iterator.next()) {
            printer.beginEntry();
            printer.printField("value", iterator.getValue());
            printer.printField("callCount", iterator.getCallCount());
            printer.printField("minValue", iterator.getMinValue());
            printer.printField("maxValue", iterator.getMaxValue());
            printer.printField("stdDev", iterator.getStdDev());
            printer.printField("data", iterator.getData());
            printer.endEntry();
        }
        printer.endEntries();
    }
}

