/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.diagnostics.serialization;

import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.serialization.CounterSerializer;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CounterSerializerFactory {
    private static final String SERIALIZATION_PACKAGE = "serialization";
    private static final String SERIALIZER_SUFFIX = "Serializer";
    private static final CounterSerializerFactory INSTANCE = new CounterSerializerFactory();
    private Map<Class<? extends Counter>, CounterSerializer> serializerCache = new ConcurrentHashMap<Class<? extends Counter>, CounterSerializer>();

    public static CounterSerializer getSerializerFor(Counter counter) {
        return INSTANCE.getSerializerForCounter(counter);
    }

    public static CounterSerializer getSerializerForType(Class<? extends Counter> counterType) {
        return INSTANCE.getSerializerForCounterType(counterType);
    }

    public CounterSerializer getSerializerForCounter(Counter counter) {
        Class<? extends Counter> counterType = counter.getType();
        return this.getSerializerForCounterType(counterType);
    }

    public CounterSerializer getSerializerForCounterType(Class<? extends Counter> counterType) {
        CounterSerializer serializer = this.serializerCache.get(counterType);
        if (serializer != null) {
            return serializer;
        }
        serializer = this.findSerializer(counterType);
        if (serializer == null) {
            throw new RuntimeException("Unable to create serializer for counter: " + counterType.getName());
        }
        this.serializerCache.put(counterType, serializer);
        return serializer;
    }

    private CounterSerializer findSerializer(Class<? extends Counter> counterType) {
        String counterName = counterType.getSimpleName();
        Package thePackage = counterType.getPackage();
        String packageName = thePackage != null ? thePackage.getName() + "." : "";
        StringBuffer buffer = new StringBuffer();
        buffer.append(packageName).append(SERIALIZATION_PACKAGE).append(".").append(counterName).append(SERIALIZER_SUFFIX);
        CounterSerializer serializer = this.instantiateSerializer(buffer.toString());
        if (serializer == null) {
            buffer.setLength(0);
            buffer.append(counterType.getName()).append(SERIALIZER_SUFFIX);
            serializer = this.instantiateSerializer(buffer.toString());
        }
        return serializer;
    }

    private CounterSerializer instantiateSerializer(String serializerClassName) {
        CounterSerializer serializer = null;
        try {
            Class<?> rawClass = Class.forName(serializerClassName);
            Class<CounterSerializer> serizalizerClass = rawClass.asSubclass(CounterSerializer.class);
            Constructor<CounterSerializer> constructor = serizalizerClass.getConstructor(new Class[0]);
            serializer = constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serializer;
    }
}

